/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.List;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public class DefUseChainComputerVisitor
implements ILogicalExpressionReferenceTransform {
    private final PushdownContext pushdownContext;
    private ILogicalOperator operator;
    private List<LogicalVariable> producedVariables;
    private int expressionIndex;

    public DefUseChainComputerVisitor(PushdownContext pushdownContext) {
        this.pushdownContext = pushdownContext;
    }

    public void init(ILogicalOperator operator, List<LogicalVariable> producedVariables) {
        this.operator = operator;
        this.producedVariables = producedVariables;
        this.expressionIndex = 0;
    }

    public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        ILogicalExpression expression = (ILogicalExpression)exprRef.getValue();
        LogicalVariable producedVariable = this.producedVariables != null ? this.producedVariables.get(this.expressionIndex) : null;
        this.pushdownContext.use(this.operator, expression, this.expressionIndex, producedVariable);
        if (producedVariable != null) {
            this.pushdownContext.define(producedVariable, this.operator, expression, this.expressionIndex);
        }
        ++this.expressionIndex;
        return false;
    }
}

