/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnTupleProjector;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.ColumnAwareMultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.column.utils.ColumnUtil;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.trace.ITracer;

public class LSMColumnBTreeOpContext
extends LSMBTreeOpContext {
    private final IColumnTupleProjector projector;

    public LSMColumnBTreeOpContext(ILSMIndex index, List<ILSMMemoryComponent> mutableComponents, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IExtendedModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int numBloomFilterKeyFields, int[] btreeFields, int[] filterFields, ILSMHarness lsmHarness, IBinaryComparatorFactory[] filterCmpFactories, ITracer tracer, IColumnTupleProjector projector) {
        super(index, mutableComponents, insertLeafFrameFactory, deleteLeafFrameFactory, modificationCallback, searchCallback, numBloomFilterKeyFields, btreeFields, filterFields, lsmHarness, filterCmpFactories, tracer);
        this.projector = projector;
    }

    public IColumnProjectionInfo createProjectionInfo() throws HyracksDataException {
        List operationalComponents = this.getComponentHolder();
        IComponentMetadata componentMetadata = null;
        for (int i = 0; i < operationalComponents.size() && componentMetadata == null; ++i) {
            ILSMComponent component = (ILSMComponent)operationalComponents.get(i);
            if (component.getType() != ILSMComponent.LSMComponentType.DISK) continue;
            componentMetadata = component.getMetadata();
        }
        if (componentMetadata != null) {
            IValueReference columnMetadata = ColumnUtil.getColumnMetadataCopy(componentMetadata);
            return this.projector.createProjectionInfo(columnMetadata);
        }
        return null;
    }

    protected MultiComparator createMultiComparator(IBinaryComparatorFactory[] cmpFactories) {
        IBinaryComparator[] comparators = new IBinaryComparator[cmpFactories.length];
        for (int i = 0; i < comparators.length; ++i) {
            comparators[i] = cmpFactories[i].createBinaryComparator();
        }
        return new ColumnAwareMultiComparator(comparators);
    }
}

