/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ClosedRecordConstructorEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory[] args;
    private ARecordType recType;

    public ClosedRecordConstructorEvalFactory(IScalarEvaluatorFactory[] args, ARecordType recType) {
        this.args = args;
        this.recType = recType;
    }

    public String toString() {
        return "ClosedRecordConstructor";
    }

    public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
        int n = this.args.length / 2;
        IScalarEvaluator[] evalFields = new IScalarEvaluator[n];
        for (int i = 0; i < n; ++i) {
            evalFields[i] = this.args[2 * i + 1].createScalarEvaluator(ctx);
        }
        return new ClosedRecordConstructorEval(this.recType, evalFields);
    }

    public static class ClosedRecordConstructorEval
    implements IScalarEvaluator {
        private IScalarEvaluator[] evalFields;
        private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private final DataOutput out = this.resultStorage.getDataOutput();
        private final IARecordBuilder recBuilder = new RecordBuilder();
        private final ARecordType recType;
        private final IPointable fieldValuePointable = new VoidPointable();
        private boolean first = true;

        public ClosedRecordConstructorEval(ARecordType recType, IScalarEvaluator[] evalFields) {
            this.evalFields = evalFields;
            this.recType = recType;
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.resultStorage.reset();
            if (this.first) {
                this.first = false;
                this.recBuilder.reset(this.recType);
            }
            this.recBuilder.init();
            for (int i = 0; i < this.evalFields.length; ++i) {
                this.evalFields[i].evaluate(tuple, this.fieldValuePointable);
                this.recBuilder.addField(i, (IValueReference)this.fieldValuePointable);
            }
            this.recBuilder.write(this.out, true);
            result.set((IValueReference)this.resultStorage);
        }
    }
}

