/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import io.netty.handler.codec.http.HttpScheme;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.app.nc.task.BindMetadataNodeTask;
import org.apache.asterix.app.nc.task.CheckpointTask;
import org.apache.asterix.app.nc.task.CloudToLocalStorageCachingTask;
import org.apache.asterix.app.nc.task.ExportMetadataNodeTask;
import org.apache.asterix.app.nc.task.LocalRecoveryTask;
import org.apache.asterix.app.nc.task.LocalStorageCleanupTask;
import org.apache.asterix.app.nc.task.MetadataBootstrapTask;
import org.apache.asterix.app.nc.task.RetrieveLibrariesTask;
import org.apache.asterix.app.nc.task.StartLifecycleComponentsTask;
import org.apache.asterix.app.nc.task.StartReplicationServiceTask;
import org.apache.asterix.app.nc.task.UpdateNodeStatusTask;
import org.apache.asterix.app.replication.message.MetadataNodeRequestMessage;
import org.apache.asterix.app.replication.message.MetadataNodeResponseMessage;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.app.replication.message.RegistrationTasksRequestMessage;
import org.apache.asterix.app.replication.message.RegistrationTasksResponseMessage;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.StorageComputePartitionsMap;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.INcLifecycleCoordinator;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.replication.messaging.ReplicaFailedMessage;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.control.IGatekeeper;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NcLifecycleCoordinator
implements INcLifecycleCoordinator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected IClusterStateManager clusterManager;
    protected volatile String metadataNodeId;
    protected Set<String> pendingStartupCompletionNodes = Collections.synchronizedSet(new HashSet());
    protected final ICCMessageBroker messageBroker;
    private final boolean replicationEnabled;
    private final IGatekeeper gatekeeper;
    Map<String, Map<String, Object>> nodeSecretsMap;
    private final ICCServiceContext serviceContext;

    public NcLifecycleCoordinator(ICCServiceContext serviceCtx, boolean replicationEnabled) {
        this.serviceContext = serviceCtx;
        this.messageBroker = (ICCMessageBroker)serviceCtx.getMessageBroker();
        this.replicationEnabled = replicationEnabled;
        this.gatekeeper = ((ClusterControllerService)serviceCtx.getControllerService()).getApplication().getGatekeeper();
        this.nodeSecretsMap = new HashMap<String, Map<String, Object>>();
    }

    public void notifyNodeJoin(String nodeId) {
        this.pendingStartupCompletionNodes.add(nodeId);
    }

    public void notifyNodeFailure(String nodeId, InetSocketAddress replicaAddress) throws HyracksDataException {
        this.pendingStartupCompletionNodes.remove(nodeId);
        this.clusterManager.updateNodeState(nodeId, false, null, null);
        if (nodeId.equals(this.metadataNodeId)) {
            this.clusterManager.updateMetadataNode(this.metadataNodeId, false);
        }
        if (replicaAddress != null) {
            this.notifyFailedReplica(this.clusterManager, nodeId, replicaAddress);
        }
        this.clusterManager.refreshState();
    }

    public void process(INCLifecycleMessage message) throws HyracksDataException {
        switch (message.getType()) {
            case REGISTRATION_TASKS_REQUEST: {
                this.process((RegistrationTasksRequestMessage)message);
                break;
            }
            case REGISTRATION_TASKS_RESULT: {
                this.process((NCLifecycleTaskReportMessage)message);
                break;
            }
            case METADATA_NODE_RESPONSE: {
                this.process((MetadataNodeResponseMessage)message);
                break;
            }
            default: {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.UNSUPPORTED_MESSAGE_TYPE, new Serializable[]{message.getType().name()});
            }
        }
    }

    public void bindTo(IClusterStateManager clusterManager) {
        this.clusterManager = clusterManager;
        this.metadataNodeId = clusterManager.getCurrentMetadataNodeId();
    }

    private void process(RegistrationTasksRequestMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        this.nodeSecretsMap.put(nodeId, msg.getSecrets());
        List<INCLifecycleTask> tasks = this.buildNCRegTasks(msg.getNodeId(), msg.getNodeStatus(), msg.getState(), msg.getActivePartitions());
        RegistrationTasksResponseMessage response = new RegistrationTasksResponseMessage(nodeId, tasks);
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)response, msg.getNodeId());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void process(NCLifecycleTaskReportMessage msg) throws HyracksDataException {
        if (!this.pendingStartupCompletionNodes.remove(msg.getNodeId())) {
            LOGGER.warn("Received unexpected startup completion message from node {}", (Object)msg.getNodeId());
        }
        if (!this.gatekeeper.isAuthorized(msg.getNodeId())) {
            LOGGER.warn("Node {} lost authorization before startup completed; ignoring registration result", (Object)msg.getNodeId());
            return;
        }
        if (msg.isSuccess()) {
            this.clusterManager.updateNodeState(msg.getNodeId(), true, msg.getLocalCounters(), msg.getActivePartitions());
            if (msg.getNodeId().equals(this.metadataNodeId)) {
                this.clusterManager.updateMetadataNode(this.metadataNodeId, true);
            }
            this.clusterManager.refreshState();
        } else {
            LOGGER.error("Node {} failed to complete startup", (Object)msg.getNodeId(), (Object)msg.getException());
        }
    }

    protected List<INCLifecycleTask> buildNCRegTasks(String nodeId, NodeStatus nodeStatus, IRecoveryManager.SystemState state, Set<Integer> activePartitions) {
        LOGGER.info("Building registration tasks for node {} with status {} and system state: {} and active partitions {}", (Object)nodeId, (Object)nodeStatus, (Object)state, activePartitions);
        boolean isMetadataNode = nodeId.equals(this.metadataNodeId);
        switch (nodeStatus) {
            case ACTIVE: {
                return this.buildActiveNCRegTasks(isMetadataNode);
            }
            case IDLE: {
                return this.buildIdleNcRegTasks(nodeId, isMetadataNode, state, activePartitions);
            }
        }
        return new ArrayList<INCLifecycleTask>();
    }

    protected List<INCLifecycleTask> buildActiveNCRegTasks(boolean metadataNode) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        if (metadataNode) {
            tasks.add(new BindMetadataNodeTask());
        }
        return tasks;
    }

    public synchronized void notifyMetadataNodeChange(String node) throws HyracksDataException {
        if (this.metadataNodeId.equals(node)) {
            return;
        }
        if (this.clusterManager.isMetadataNodeActive()) {
            MetadataNodeRequestMessage msg = new MetadataNodeRequestMessage(false, this.clusterManager.getMetadataPartition().getPartitionId());
            try {
                this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)msg, this.metadataNodeId);
                this.metadataNodeId = node;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        } else {
            this.requestMetadataNodeTakeover(node);
        }
    }

    protected List<INCLifecycleTask> buildIdleNcRegTasks(String newNodeId, boolean metadataNode, IRecoveryManager.SystemState state, Set<Integer> activePartitions) {
        Set nodes;
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        Set<Integer> nodeActivePartitions = this.getNodeActivePartitions(newNodeId, activePartitions, metadataNode, state);
        tasks.add(new UpdateNodeStatusTask(NodeStatus.BOOTING, nodeActivePartitions));
        int metadataPartitionId = this.clusterManager.getMetadataPartition().getPartitionId();
        this.addCloudTasks(tasks, nodeActivePartitions, metadataNode, metadataPartitionId, state == IRecoveryManager.SystemState.CORRUPTED);
        tasks.add(new LocalStorageCleanupTask(metadataPartitionId));
        if (state == IRecoveryManager.SystemState.CORRUPTED) {
            LocalRecoveryTask rt = new LocalRecoveryTask(nodeActivePartitions);
            tasks.add(rt);
        }
        if (this.replicationEnabled) {
            tasks.add(new StartReplicationServiceTask());
        }
        if (metadataNode) {
            tasks.add(new MetadataBootstrapTask(metadataPartitionId));
        }
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        if (this.isLibraryFetchEnabled() && this.clusterManager.getState() == IClusterManagementWork.ClusterState.ACTIVE && (nodes = this.clusterManager.getParticipantNodes(true)).size() > 0) {
            try {
                tasks.add(this.nodesToLibraryTask(newNodeId, nodes));
            }
            catch (HyracksDataException e) {
                LOGGER.error("Could not construct library recovery task", (Throwable)e);
            }
        }
        if (metadataNode) {
            tasks.add(new ExportMetadataNodeTask(true));
            tasks.add(new BindMetadataNodeTask());
        }
        tasks.add(new UpdateNodeStatusTask(NodeStatus.ACTIVE, nodeActivePartitions));
        return tasks;
    }

    protected void addCloudTasks(List<INCLifecycleTask> tasks, Set<Integer> computePartitions, boolean metadataNode, int metadataPartitionId, boolean cleanup) {
        IApplicationContext appCtx = (IApplicationContext)this.serviceContext.getApplicationContext();
        if (!appCtx.isCloudDeployment()) {
            return;
        }
        StorageComputePartitionsMap map = this.clusterManager.getStorageComputeMap();
        map = map == null ? StorageComputePartitionsMap.computePartitionsMap((IClusterStateManager)this.clusterManager) : map;
        Set storagePartitions = map.getStoragePartitions(computePartitions);
        tasks.add(new CloudToLocalStorageCachingTask(storagePartitions, metadataNode, metadataPartitionId, cleanup));
    }

    private synchronized void process(MetadataNodeResponseMessage response) throws HyracksDataException {
        MetadataManager.INSTANCE.rebindMetadataNode();
        this.clusterManager.updateMetadataNode(response.getNodeId(), response.isExported());
        if (!response.isExported()) {
            this.requestMetadataNodeTakeover(this.metadataNodeId);
        }
    }

    protected String getNCAuthToken(String node) {
        return (String)this.nodeSecretsMap.get(node).get("org.apache.asterix.SYS_AUTH_HEADER");
    }

    protected URI constructNCRecoveryUri(String nodeId) throws HyracksDataException {
        Map nodeConfig = (Map)this.clusterManager.getNcConfiguration().get(nodeId);
        String host = (String)nodeConfig.get(NCConfig.Option.PUBLIC_ADDRESS);
        int port = (Integer)nodeConfig.get(ExternalProperties.Option.NC_API_PORT);
        URIBuilder builder = new URIBuilder().setScheme(HttpScheme.HTTP.toString()).setHost(host).setPort(port);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Could not find URL for NC recovery", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void requestMetadataNodeTakeover(String node) throws HyracksDataException {
        MetadataNodeRequestMessage msg = new MetadataNodeRequestMessage(true, this.clusterManager.getMetadataPartition().getPartitionId());
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)msg, node);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected RetrieveLibrariesTask nodesToLibraryTask(String newNodeId, Set<String> referenceNodes) throws HyracksDataException {
        ArrayList<Pair<URI, String>> referenceNodeLocAndAuth = new ArrayList<Pair<URI, String>>();
        for (String node : referenceNodes) {
            referenceNodeLocAndAuth.add((Pair<URI, String>)new Pair((Object)this.constructNCRecoveryUri(node), (Object)this.getNCAuthToken(node)));
        }
        return this.getRetrieveLibrariesTask(referenceNodeLocAndAuth);
    }

    protected RetrieveLibrariesTask getRetrieveLibrariesTask(List<Pair<URI, String>> referenceNodeLocAndAuth) {
        return new RetrieveLibrariesTask(referenceNodeLocAndAuth);
    }

    protected boolean isLibraryFetchEnabled() {
        return true;
    }

    protected Set<Integer> getNodeActivePartitions(String nodeId, Set<Integer> nodePartitions, boolean metadataNode, IRecoveryManager.SystemState state) {
        if (metadataNode) {
            nodePartitions.add(this.clusterManager.getMetadataPartition().getPartitionId());
        }
        return nodePartitions;
    }

    private void notifyFailedReplica(IClusterStateManager clusterManager, String nodeID, InetSocketAddress replicaAddress) {
        if (!this.replicationEnabled) {
            return;
        }
        LOGGER.info("notify replica failure of nodeId {} at {}", (Object)nodeID, (Object)replicaAddress);
        Set ncs = clusterManager.getParticipantNodes(true);
        ReplicaFailedMessage message = new ReplicaFailedMessage(replicaAddress, (Exception)((Object)HyracksDataException.create((ErrorCode)ErrorCode.NODE_FAILED, (Serializable[])new Serializable[]{nodeID})));
        for (String nodeId : ncs) {
            try {
                this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)message, nodeId);
            }
            catch (Exception e) {
                LOGGER.info("failed to notify replica failure to node {}", (Object)nodeID);
            }
        }
    }
}

