/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectBlock
extends AbstractClause {
    private SelectClause selectClause;
    private FromClause fromClause;
    private final List<AbstractClause> letWhereClauses = new ArrayList<AbstractClause>();
    private GroupbyClause groupbyClause;
    private final List<AbstractClause> letHavingClausesAfterGby = new ArrayList<AbstractClause>();

    public SelectBlock(SelectClause selectClause, FromClause fromClause, List<AbstractClause> letWhereClauses, GroupbyClause groupbyClause, List<AbstractClause> letHavingClausesAfterGby) {
        this.selectClause = selectClause;
        this.fromClause = fromClause;
        if (letWhereClauses != null) {
            this.letWhereClauses.addAll(letWhereClauses);
        }
        this.groupbyClause = groupbyClause;
        if (letHavingClausesAfterGby != null) {
            this.letHavingClausesAfterGby.addAll(letHavingClausesAfterGby);
        }
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_BLOCK;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public List<AbstractClause> getLetWhereList() {
        return this.letWhereClauses;
    }

    public GroupbyClause getGroupbyClause() {
        return this.groupbyClause;
    }

    public void setGroupbyClause(GroupbyClause groupbyClause) {
        this.groupbyClause = groupbyClause;
    }

    public List<AbstractClause> getLetHavingListAfterGroupby() {
        return this.letHavingClausesAfterGby;
    }

    public boolean hasFromClause() {
        return this.fromClause != null;
    }

    public boolean hasLetWhereClauses() {
        return !this.letWhereClauses.isEmpty();
    }

    public boolean hasGroupbyClause() {
        return this.groupbyClause != null;
    }

    public boolean hasLetHavingClausesAfterGroupby() {
        return !this.letHavingClausesAfterGby.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fromClause, this.groupbyClause, this.letWhereClauses, this.letHavingClausesAfterGby, this.selectClause});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectBlock)) {
            return false;
        }
        SelectBlock target = (SelectBlock)((Object)object);
        return Objects.equals((Object)this.fromClause, (Object)target.fromClause) && Objects.equals(this.groupbyClause, target.groupbyClause) && Objects.equals(this.letWhereClauses, target.letWhereClauses) && Objects.equals(this.letHavingClausesAfterGby, target.letHavingClausesAfterGby) && Objects.equals((Object)this.selectClause, (Object)target.selectClause);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.selectClause);
        if (this.hasFromClause()) {
            sb.append(' ').append((Object)this.fromClause);
        }
        if (this.hasLetWhereClauses()) {
            sb.append(' ').append(this.letWhereClauses);
        }
        if (this.hasGroupbyClause()) {
            sb.append(' ').append(this.groupbyClause);
        }
        if (this.hasLetHavingClausesAfterGroupby()) {
            sb.append(' ').append(this.letHavingClausesAfterGby);
        }
        return sb.toString();
    }
}

