/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor.base;

import java.util.Collection;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.CopyToStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public abstract class AbstractSqlppContainsExpressionVisitor<T>
extends AbstractSqlppQueryExpressionVisitor<Boolean, T> {
    @Override
    public Boolean visit(FromClause fromClause, T arg) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            if (!((Boolean)fromTerm.accept(this, arg)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(FromTerm fromTerm, T arg) throws CompilationException {
        if (this.visit((ILangExpression)fromTerm.getLeftExpression(), arg)) {
            return true;
        }
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                if (!((Boolean)correlateClause.accept(this, arg)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean visit(JoinClause joinClause, T arg) throws CompilationException {
        return this.visit((ILangExpression)joinClause.getRightExpression(), arg) || this.visit((ILangExpression)joinClause.getConditionExpression(), arg);
    }

    @Override
    public Boolean visit(NestClause nestClause, T arg) throws CompilationException {
        return (Boolean)nestClause.accept(this, arg);
    }

    @Override
    public Boolean visit(Projection projection, T arg) throws CompilationException {
        return this.visit((ILangExpression)projection.getExpression(), arg);
    }

    @Override
    public Boolean visit(SelectBlock selectBlock, T arg) throws CompilationException {
        return selectBlock.hasFromClause() && ((Boolean)this.visit(selectBlock.getFromClause(), (Object)arg)).booleanValue() || selectBlock.hasLetWhereClauses() && this.visitExprList(selectBlock.getLetWhereList(), arg) || selectBlock.hasGroupbyClause() && ((Boolean)this.visit(selectBlock.getGroupbyClause(), (Object)arg)).booleanValue() || selectBlock.hasLetHavingClausesAfterGroupby() && this.visitExprList(selectBlock.getLetHavingListAfterGroupby(), arg) || ((Boolean)this.visit(selectBlock.getSelectClause(), (Object)arg)).booleanValue();
    }

    @Override
    public Boolean visit(SelectClause selectClause, T arg) throws CompilationException {
        return selectClause.selectElement() && ((Boolean)this.visit(selectClause.getSelectElement(), (Object)arg)).booleanValue() || selectClause.selectRegular() && ((Boolean)this.visit(selectClause.getSelectRegular(), (Object)arg)).booleanValue();
    }

    @Override
    public Boolean visit(SelectElement selectElement, T arg) throws CompilationException {
        return this.visit((ILangExpression)selectElement.getExpression(), arg);
    }

    @Override
    public Boolean visit(SelectRegular selectRegular, T arg) throws CompilationException {
        return this.visitExprList(selectRegular.getProjections(), arg);
    }

    @Override
    public Boolean visit(SelectSetOperation selectSetOperation, T arg) throws CompilationException {
        if (((Boolean)selectSetOperation.getLeftInput().accept(this, arg)).booleanValue()) {
            return true;
        }
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                if (!((Boolean)right.getSetOperationRightInput().accept(this, arg)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean visit(SelectExpression selectStatement, T arg) throws CompilationException {
        return selectStatement.hasLetClauses() && this.visitExprList(selectStatement.getLetList(), arg) || ((Boolean)this.visit(selectStatement.getSelectSetOperation(), (Object)arg)).booleanValue() || selectStatement.hasOrderby() && ((Boolean)this.visit(selectStatement.getOrderbyClause(), (Object)arg)).booleanValue() || selectStatement.hasLimit() && ((Boolean)this.visit(selectStatement.getLimitClause(), (Object)arg)).booleanValue();
    }

    @Override
    public Boolean visit(UnnestClause unnestClause, T arg) throws CompilationException {
        return this.visit((ILangExpression)unnestClause.getRightExpression(), arg);
    }

    @Override
    public Boolean visit(HavingClause havingClause, T arg) throws CompilationException {
        return this.visit((ILangExpression)havingClause.getFilterExpression(), arg);
    }

    @Override
    public Boolean visit(CaseExpression caseExpression, T arg) throws CompilationException {
        return this.visit((ILangExpression)caseExpression.getConditionExpr(), arg) || this.visitExprList(caseExpression.getWhenExprs(), arg) || this.visitExprList(caseExpression.getThenExprs(), arg) || this.visit((ILangExpression)caseExpression.getElseExpr(), arg);
    }

    public Boolean visit(LiteralExpr l, T arg) throws CompilationException {
        return false;
    }

    public Boolean visit(VariableExpr v, T arg) throws CompilationException {
        return false;
    }

    public Boolean visit(ListConstructor lc, T arg) throws CompilationException {
        return this.visitExprList(lc.getExprList(), arg);
    }

    public Boolean visit(RecordConstructor rc, T arg) throws CompilationException {
        for (FieldBinding fb : rc.getFbList()) {
            if (this.visit((ILangExpression)fb.getLeftExpr(), arg)) {
                return true;
            }
            if (!this.visit((ILangExpression)fb.getRightExpr(), arg)) continue;
            return true;
        }
        return false;
    }

    public Boolean visit(OperatorExpr operatorExpr, T arg) throws CompilationException {
        return this.visitExprList(operatorExpr.getExprList(), arg);
    }

    public Boolean visit(FieldAccessor fa, T arg) throws CompilationException {
        return this.visit((ILangExpression)fa.getExpr(), arg);
    }

    public Boolean visit(IndexAccessor ia, T arg) throws CompilationException {
        return this.visit((ILangExpression)ia.getExpr(), arg) || this.visit((ILangExpression)ia.getIndexExpr(), arg);
    }

    public Boolean visit(ListSliceExpression expression, T arg) throws CompilationException {
        return this.visit((ILangExpression)expression.getExpr(), arg) || this.visit((ILangExpression)expression.getStartIndexExpression(), arg) || this.visit((ILangExpression)expression.getEndIndexExpression(), arg);
    }

    public Boolean visit(IfExpr ifexpr, T arg) throws CompilationException {
        return this.visit((ILangExpression)ifexpr.getCondExpr(), arg) || this.visit((ILangExpression)ifexpr.getThenExpr(), arg) || this.visit((ILangExpression)ifexpr.getElseExpr(), arg);
    }

    public Boolean visit(QuantifiedExpression qe, T arg) throws CompilationException {
        for (QuantifiedPair qf : qe.getQuantifiedList()) {
            if (!this.visit((ILangExpression)qf.getExpr(), arg)) continue;
            return true;
        }
        return this.visit((ILangExpression)qe.getSatisfiesExpr(), arg);
    }

    public Boolean visit(LetClause lc, T arg) throws CompilationException {
        return this.visit((ILangExpression)lc.getBindingExpr(), arg);
    }

    public Boolean visit(WhereClause wc, T arg) throws CompilationException {
        return this.visit((ILangExpression)wc.getWhereExpr(), arg);
    }

    public Boolean visit(OrderbyClause oc, T arg) throws CompilationException {
        return this.visitExprList(oc.getOrderbyList(), arg);
    }

    public Boolean visit(GroupbyClause gc, T arg) throws CompilationException {
        for (List gbyPairList : gc.getGbyPairList()) {
            for (GbyVariableExpressionPair key : gbyPairList) {
                if (!this.visit((ILangExpression)key.getExpr(), arg)) continue;
                return true;
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair key : gc.getDecorPairList()) {
                if (!this.visit((ILangExpression)key.getExpr(), arg)) continue;
                return true;
            }
        }
        if (gc.hasGroupFieldList() && this.visitFieldList(gc.getGroupFieldList(), arg)) {
            return true;
        }
        if (gc.hasWithMap() && this.visitExprList(gc.getWithVarMap().keySet(), arg)) {
            return true;
        }
        return false;
    }

    public Boolean visit(LimitClause lc, T arg) throws CompilationException {
        return this.visit((ILangExpression)lc.getLimitExpr(), arg) || this.visit((ILangExpression)lc.getOffset(), arg);
    }

    public Boolean visit(UnaryExpr u, T arg) throws CompilationException {
        return this.visit((ILangExpression)u.getExpr(), arg);
    }

    @Override
    public Boolean visit(WindowExpression winExpr, T arg) throws CompilationException {
        return winExpr.hasPartitionList() && this.visitExprList(winExpr.getPartitionList(), arg) || winExpr.hasOrderByList() && this.visitExprList(winExpr.getOrderbyList(), arg) || winExpr.hasFrameStartExpr() && this.visit((ILangExpression)winExpr.getFrameStartExpr(), arg) || winExpr.hasFrameEndExpr() && this.visit((ILangExpression)winExpr.getFrameEndExpr(), arg) || winExpr.hasWindowFieldList() && this.visitFieldList(winExpr.getWindowFieldList(), arg) || winExpr.hasAggregateFilterExpr() && this.visit((ILangExpression)winExpr.getAggregateFilterExpr(), arg) || this.visitExprList(winExpr.getExprList(), arg);
    }

    public Boolean visit(CallExpr callExpr, T arg) throws CompilationException {
        return this.visitExprList(callExpr.getExprList(), arg) || callExpr.hasAggregateFilterExpr() && this.visit((ILangExpression)callExpr.getAggregateFilterExpr(), arg);
    }

    public Boolean visit(CopyToStatement stmtCopy, T arg) throws CompilationException {
        return (Boolean)stmtCopy.accept((ILangVisitor)this, arg) != false || this.visitExprList(stmtCopy.getPathExpressions(), arg) || this.visitExprList(stmtCopy.getPartitionExpressions(), arg) || this.visitExprList(stmtCopy.getOrderByList(), arg);
    }

    private boolean visit(ILangExpression expr, T arg) throws CompilationException {
        return expr != null && (Boolean)expr.accept((ILangVisitor)this, arg) != false;
    }

    private <E extends ILangExpression> boolean visitExprList(Collection<E> exprList, T arg) throws CompilationException {
        for (ILangExpression langExpr : exprList) {
            if (!this.visit(langExpr, arg)) continue;
            return true;
        }
        return false;
    }

    private <E extends ILangExpression> boolean visitFieldList(Collection<Pair<E, Identifier>> fieldList, T arg) throws CompilationException {
        for (Pair<E, Identifier> p : fieldList) {
            if (!this.visit((ILangExpression)p.first, arg)) continue;
            return true;
        }
        return false;
    }
}

