/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputer;

public class FieldHashPartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 2L;
    private final int[] hashFields;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final int[][] partitionsMap;

    public static FieldHashPartitionComputerFactory of(int[] hashFields, IBinaryHashFunctionFactory[] hashFunctionFactories) {
        return new FieldHashPartitionComputerFactory(hashFields, hashFunctionFactories, null);
    }

    public static FieldHashPartitionComputerFactory withMap(int[] hashFields, IBinaryHashFunctionFactory[] hashFunctionFactories, int[][] partitionsMap) {
        return new FieldHashPartitionComputerFactory(hashFields, hashFunctionFactories, partitionsMap);
    }

    private FieldHashPartitionComputerFactory(int[] hashFields, IBinaryHashFunctionFactory[] hashFunctionFactories, int[][] partitionsMap) {
        this.hashFields = hashFields;
        this.hashFunctionFactories = hashFunctionFactories;
        this.partitionsMap = partitionsMap;
    }

    public ITuplePartitionComputer createPartitioner(IHyracksTaskContext ctx) {
        IBinaryHashFunction[] hashFunctions = new IBinaryHashFunction[this.hashFunctionFactories.length];
        for (int i = 0; i < this.hashFunctionFactories.length; ++i) {
            hashFunctions[i] = this.hashFunctionFactories[i].createBinaryHashFunction();
        }
        if (this.partitionsMap == null) {
            return new FieldHashPartitionComputer(this.hashFields, hashFunctions, null);
        }
        Int2IntOpenHashMap storagePartition2Compute = new Int2IntOpenHashMap();
        for (int i = 0; i < this.partitionsMap.length; ++i) {
            for (int storagePartition : this.partitionsMap[i]) {
                storagePartition2Compute.put(storagePartition, i);
            }
        }
        return new FieldHashPartitionComputer(this.hashFields, hashFunctions, (Int2IntMap)storagePartition2Compute);
    }
}

