/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.writer;

import com.google.common.base.Utf8;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.asterix.cloud.CloudOutputStream;
import org.apache.asterix.cloud.CloudResettableInputStream;
import org.apache.asterix.cloud.IWriteBufferProvider;
import org.apache.asterix.cloud.WriterSingleBufferProvider;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.runtime.writer.IExternalFilePrinter;
import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.data.std.api.IValueReference;

abstract class AbstractCloudExternalFileWriter
implements IExternalFileWriter {
    private final IExternalFilePrinter printer;
    private final ICloudClient cloudClient;
    private final String bucket;
    private final boolean partitionedPath;
    private final IWarningCollector warningCollector;
    private final SourceLocation pathSourceLocation;
    private final IWriteBufferProvider bufferProvider;
    private ICloudBufferedWriter bufferedWriter;

    AbstractCloudExternalFileWriter(IExternalFilePrinter printer, ICloudClient cloudClient, String bucket, boolean partitionedPath, IWarningCollector warningCollector, SourceLocation pathSourceLocation) {
        this.printer = printer;
        this.cloudClient = cloudClient;
        this.bucket = bucket;
        this.partitionedPath = partitionedPath;
        this.warningCollector = warningCollector;
        this.pathSourceLocation = pathSourceLocation;
        this.bufferProvider = new WriterSingleBufferProvider();
    }

    public final void open() throws HyracksDataException {
        this.printer.open();
    }

    public void validate(String directory) throws HyracksDataException {
        if (this.checkAndWarnExceedingMaxLength(directory)) {
            return;
        }
        if (this.partitionedPath && !this.cloudClient.isEmptyPrefix(this.bucket, directory)) {
            throw new RuntimeDataException(ErrorCode.DIRECTORY_IS_NOT_EMPTY, this.pathSourceLocation, new Serializable[]{directory});
        }
    }

    public final boolean newFile(String directory, String fileName) throws HyracksDataException {
        String fullPath = directory + fileName;
        if (this.checkAndWarnExceedingMaxLength(fullPath)) {
            return false;
        }
        this.bufferedWriter = this.cloudClient.createBufferedWriter(this.bucket, fullPath);
        CloudResettableInputStream inputStream = new CloudResettableInputStream(this.bufferedWriter, this.bufferProvider);
        CloudOutputStream outputStream = new CloudOutputStream(inputStream);
        this.printer.newStream((OutputStream)outputStream);
        return true;
    }

    public final void write(IValueReference value) throws HyracksDataException {
        try {
            this.printer.print(value);
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.isSdkException(e)) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)e, (Serializable[])new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e)});
            }
            throw e;
        }
    }

    public final void abort() throws HyracksDataException {
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.abort();
            }
            this.printer.close();
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.isSdkException(e)) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)e, (Serializable[])new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e)});
            }
            throw e;
        }
    }

    public final void close() throws HyracksDataException {
        try {
            this.printer.close();
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.isSdkException(e)) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)e, (Serializable[])new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e)});
            }
            throw e;
        }
    }

    abstract String getAdapterName();

    abstract int getPathMaxLengthInBytes();

    abstract boolean isSdkException(Exception var1);

    private boolean checkAndWarnExceedingMaxLength(String fullPath) {
        boolean exceeding = AbstractCloudExternalFileWriter.isExceedingMaxLength(fullPath, this.getPathMaxLengthInBytes());
        if (exceeding && this.warningCollector.shouldWarn()) {
            this.warningCollector.warn(Warning.of((SourceLocation)this.pathSourceLocation, (IError)ErrorCode.WRITE_PATH_LENGTH_EXCEEDS_MAX_LENGTH, (Serializable[])new Serializable[]{fullPath, Integer.valueOf(this.getPathMaxLengthInBytes()), this.getAdapterName()}));
        }
        return exceeding;
    }

    static boolean isExceedingMaxLength(String path, int maxLength) {
        return Utf8.encodedLength((CharSequence)path) >= maxLength;
    }
}

