/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFilterManager;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.PartitionSet;

public class BaseReplacePartitions
extends MergingSnapshotProducer<ReplacePartitions>
implements ReplacePartitions {
    private final PartitionSet replacedPartitions;
    private Long startingSnapshotId;
    private boolean validateConflictingData = false;
    private boolean validateConflictingDeletes = false;

    BaseReplacePartitions(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.set("replace-partitions", "true");
        this.replacedPartitions = PartitionSet.create(ops.current().specsById());
    }

    @Override
    protected ReplacePartitions self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    public ReplacePartitions addFile(DataFile file) {
        this.dropPartition(file.specId(), file.partition());
        this.replacedPartitions.add(file.specId(), file.partition());
        this.add(file);
        return this;
    }

    public ReplacePartitions validateAppendOnly() {
        this.failAnyDelete();
        return this;
    }

    public ReplacePartitions validateFromSnapshot(long newStartingSnapshotId) {
        this.startingSnapshotId = newStartingSnapshotId;
        return this;
    }

    public ReplacePartitions validateNoConflictingDeletes() {
        this.validateConflictingDeletes = true;
        return this;
    }

    public ReplacePartitions validateNoConflictingData() {
        this.validateConflictingData = true;
        return this;
    }

    @Override
    @Deprecated
    public void validate(TableMetadata currentMetadata) {
        super.validate(currentMetadata);
    }

    @Override
    public void validate(TableMetadata currentMetadata, Snapshot snapshot) {
        if (this.validateConflictingData) {
            if (this.dataSpec().isUnpartitioned()) {
                this.validateAddedDataFiles(currentMetadata, this.startingSnapshotId, (Expression)Expressions.alwaysTrue());
            } else {
                this.validateAddedDataFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions);
            }
        }
        if (this.validateConflictingDeletes) {
            if (this.dataSpec().isUnpartitioned()) {
                this.validateDeletedDataFiles(currentMetadata, this.startingSnapshotId, (Expression)Expressions.alwaysTrue());
                this.validateNoNewDeleteFiles(currentMetadata, this.startingSnapshotId, (Expression)Expressions.alwaysTrue());
            } else {
                this.validateDeletedDataFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions);
                this.validateNoNewDeleteFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions);
            }
        }
    }

    @Override
    @Deprecated
    public List<ManifestFile> apply(TableMetadata base) {
        return super.apply(base);
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base, Snapshot snapshot) {
        if (this.dataSpec().fields().size() <= 0) {
            this.deleteByRowFilter((Expression)Expressions.alwaysTrue());
        }
        try {
            return super.apply(base, snapshot);
        }
        catch (ManifestFilterManager.DeleteException e) {
            throw new ValidationException("Cannot commit file that conflicts with existing partition: %s", new Object[]{e.partition()});
        }
    }
}

