/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.IOException;
import java.net.InetAddress;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.MachineList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ServiceAuthorizationManager {
    static final String BLOCKED = ".blocked";
    static final String HOSTS = ".hosts";
    private static final String HADOOP_POLICY_FILE = "hadoop-policy.xml";
    private volatile Map<Class<?>, AccessControlList[]> protocolToAcls = new IdentityHashMap();
    private volatile Map<Class<?>, MachineList[]> protocolToMachineLists = new IdentityHashMap();
    @Deprecated
    public static final String SERVICE_AUTHORIZATION_CONFIG = "hadoop.security.authorization";
    public static final Logger AUDITLOG = LoggerFactory.getLogger("SecurityLogger." + ServiceAuthorizationManager.class.getName());
    private static final String AUTHZ_SUCCESSFUL_FOR = "Authorization successful for ";
    private static final String AUTHZ_FAILED_FOR = "Authorization failed for ";

    public void authorize(UserGroupInformation user, Class<?> protocol, Configuration conf, InetAddress addr) throws AuthorizationException {
        AccessControlList[] acls = this.protocolToAcls.get(protocol);
        MachineList[] hosts = this.protocolToMachineLists.get(protocol);
        if (acls == null || hosts == null) {
            throw new AuthorizationException("Protocol " + protocol + " is not known.");
        }
        String clientPrincipal = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            clientPrincipal = SecurityUtil.getClientPrincipal(protocol, conf);
            try {
                if (clientPrincipal != null) {
                    clientPrincipal = SecurityUtil.getServerPrincipal(clientPrincipal, addr);
                }
            }
            catch (IOException e) {
                throw (AuthorizationException)new AuthorizationException("Can't figure out Kerberos principal name for connection from " + addr + " for user=" + user + " protocol=" + protocol).initCause(e);
            }
        }
        if (clientPrincipal != null && !clientPrincipal.equals(user.getUserName()) || acls.length != 2 || !acls[0].isUserAllowed(user) || acls[1].isUserAllowed(user)) {
            String cause = clientPrincipal != null ? ": this service is only accessible by " + clientPrincipal : ": denied by configured ACL";
            AUDITLOG.warn(AUTHZ_FAILED_FOR + user + " for protocol=" + protocol + cause);
            throw new AuthorizationException("User " + user + " is not authorized for protocol " + protocol + cause);
        }
        if (addr != null) {
            String hostAddress = addr.getHostAddress();
            if (hosts.length != 2 || !hosts[0].includes(hostAddress) || hosts[1].includes(hostAddress)) {
                AUDITLOG.warn("Authorization failed for  for protocol=" + protocol + " from host = " + hostAddress);
                throw new AuthorizationException("Host " + hostAddress + " is not authorized for protocol " + protocol);
            }
        }
        AUDITLOG.info(AUTHZ_SUCCESSFUL_FOR + user + " for protocol=" + protocol);
    }

    public void refresh(Configuration conf, PolicyProvider provider) {
        String policyFile = System.getProperty("hadoop.policy.file", HADOOP_POLICY_FILE);
        Configuration policyConf = new Configuration(conf);
        policyConf.addResource(policyFile);
        this.refreshWithLoadedConfiguration(policyConf, provider);
    }

    @InterfaceAudience.Private
    public void refreshWithLoadedConfiguration(Configuration conf, PolicyProvider provider) {
        IdentityHashMap newAcls = new IdentityHashMap();
        IdentityHashMap newMachineLists = new IdentityHashMap();
        String defaultAcl = conf.get("security.service.authorization.default.acl", "*");
        String defaultBlockedAcl = conf.get("security.service.authorization.default.acl.blocked", "");
        String defaultServiceHostsKey = this.getHostKey("security.service.authorization.default.acl");
        String defaultMachineList = conf.get(defaultServiceHostsKey, "*");
        String defaultBlockedMachineList = conf.get(defaultServiceHostsKey + BLOCKED, "");
        Service[] services = provider.getServices();
        if (services != null) {
            for (Service service : services) {
                AccessControlList acl = new AccessControlList(conf.get(service.getServiceKey(), defaultAcl));
                AccessControlList blockedAcl = new AccessControlList(conf.get(service.getServiceKey() + BLOCKED, defaultBlockedAcl));
                newAcls.put(service.getProtocol(), new AccessControlList[]{acl, blockedAcl});
                String serviceHostsKey = this.getHostKey(service.getServiceKey());
                MachineList machineList = new MachineList(conf.get(serviceHostsKey, defaultMachineList));
                MachineList blockedMachineList = new MachineList(conf.get(serviceHostsKey + BLOCKED, defaultBlockedMachineList));
                newMachineLists.put(service.getProtocol(), new MachineList[]{machineList, blockedMachineList});
            }
        }
        this.protocolToAcls = newAcls;
        this.protocolToMachineLists = newMachineLists;
    }

    private String getHostKey(String serviceKey) {
        int endIndex = serviceKey.lastIndexOf(".");
        if (endIndex != -1) {
            return serviceKey.substring(0, endIndex) + HOSTS;
        }
        return serviceKey;
    }

    @VisibleForTesting
    public Set<Class<?>> getProtocolsWithAcls() {
        return this.protocolToAcls.keySet();
    }

    @VisibleForTesting
    public AccessControlList getProtocolsAcls(Class<?> className) {
        return this.protocolToAcls.get(className)[0];
    }

    @VisibleForTesting
    public AccessControlList getProtocolsBlockedAcls(Class<?> className) {
        return this.protocolToAcls.get(className)[1];
    }

    @VisibleForTesting
    public Set<Class<?>> getProtocolsWithMachineLists() {
        return this.protocolToMachineLists.keySet();
    }

    @VisibleForTesting
    public MachineList getProtocolsMachineList(Class<?> className) {
        return this.protocolToMachineLists.get(className)[0];
    }

    @VisibleForTesting
    public MachineList getProtocolsBlockedMachineList(Class<?> className) {
        return this.protocolToMachineLists.get(className)[1];
    }
}

