/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.ccache.Credential;
import org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import org.apache.kerby.kerberos.kerb.client.ClientUtil;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.kerby.kerberos.kerb.client.impl.DefaultInternalKrbClient;
import org.apache.kerby.kerberos.kerb.client.impl.InternalKrbClient;
import org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbClientBase {
    private final KrbConfig krbConfig;
    private final KOptions commonOptions;
    private final KrbSetting krbSetting;
    private InternalKrbClient innerClient;
    private static final Logger LOG = LoggerFactory.getLogger(KrbClientBase.class);

    public KrbClientBase() throws KrbException {
        this.krbConfig = ClientUtil.getDefaultConfig();
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbConfig krbConfig) {
        this.krbConfig = krbConfig;
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, krbConfig);
    }

    public KrbClientBase(File confDir) throws KrbException {
        this.commonOptions = new KOptions();
        this.krbConfig = ClientUtil.getConfig(confDir);
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbClientBase krbClient) {
        this.commonOptions = krbClient.commonOptions;
        this.krbConfig = krbClient.krbConfig;
        this.krbSetting = krbClient.krbSetting;
        this.innerClient = krbClient.innerClient;
    }

    public void setKdcRealm(String realm) {
        this.commonOptions.add(KrbOption.KDC_REALM, realm);
    }

    public void setKdcHost(String kdcHost) {
        this.commonOptions.add(KrbOption.KDC_HOST, kdcHost);
    }

    public void setKdcTcpPort(int kdcTcpPort) {
        if (kdcTcpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(KrbOption.KDC_TCP_PORT, kdcTcpPort);
        this.setAllowTcp(true);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.commonOptions.add(KrbOption.ALLOW_UDP, allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.commonOptions.add(KrbOption.ALLOW_TCP, allowTcp);
    }

    public void setKdcUdpPort(int kdcUdpPort) {
        if (kdcUdpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(KrbOption.KDC_UDP_PORT, kdcUdpPort);
        this.setAllowUdp(true);
    }

    public void setTimeout(int timeout) {
        this.commonOptions.add(KrbOption.CONN_TIMEOUT, timeout);
    }

    public void init() throws KrbException {
        this.innerClient = new DefaultInternalKrbClient(this.krbSetting);
        this.innerClient.init();
    }

    public KrbSetting getSetting() {
        return this.krbSetting;
    }

    public KrbConfig getKrbConfig() {
        return this.krbConfig;
    }

    public TgtTicket requestTgt(KOptions requestOptions) throws KrbException {
        if (requestOptions == null) {
            throw new IllegalArgumentException("Null requestOptions specified");
        }
        return this.innerClient.requestTgt(requestOptions);
    }

    public SgtTicket requestSgt(TgtTicket tgt, String serverPrincipal) throws KrbException {
        KOptions requestOptions = new KOptions();
        requestOptions.add(KrbOption.USE_TGT, tgt);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, serverPrincipal);
        return this.innerClient.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(KOptions requestOptions) throws KrbException {
        return this.innerClient.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(File ccFile) throws KrbException {
        Credential credential = this.getCredentialFromFile(ccFile);
        String servicePrincipal = credential.getServicePrincipal().getName();
        TgtTicket tgt = this.getTgtTicketFromCredential(credential);
        KOptions requestOptions = new KOptions();
        requestOptions.add(KrbKdcOption.RENEW);
        requestOptions.add(KrbOption.USE_TGT, tgt);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, servicePrincipal);
        SgtTicket sgtTicket = this.innerClient.requestSgt(requestOptions);
        sgtTicket.setClientPrincipal(tgt.getClientPrincipal());
        return sgtTicket;
    }

    public void storeTicket(TgtTicket tgtTicket, File ccacheFile) throws KrbException {
        LOG.info("Storing the tgt to the credential cache file.");
        if (!ccacheFile.exists()) {
            try {
                if (!ccacheFile.createNewFile()) {
                    throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath());
                }
                ccacheFile.setReadable(false, false);
                ccacheFile.setReadable(true, true);
                if (!ccacheFile.setWritable(true, true)) {
                    throw new KrbException("Cache file is not readable.");
                }
            }
            catch (IOException e) {
                throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(tgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to store tgt", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    public void storeTicket(SgtTicket sgtTicket, File ccacheFile) throws KrbException {
        LOG.info("Storing the sgt to the credential cache file.");
        if (!ccacheFile.exists()) {
            try {
                if (!ccacheFile.createNewFile()) {
                    throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath());
                }
                ccacheFile.setReadable(false, false);
                ccacheFile.setReadable(true, true);
                if (!ccacheFile.setWritable(true, true)) {
                    throw new KrbException("Cache file is not readable.");
                }
            }
            catch (IOException e) {
                throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(sgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to store tgt", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    public TgtTicket getTgtTicketFromCredential(Credential cc) {
        EncAsRepPart encAsRepPart = new EncAsRepPart();
        encAsRepPart.setAuthTime(cc.getAuthTime());
        encAsRepPart.setCaddr(cc.getClientAddresses());
        encAsRepPart.setEndTime(cc.getEndTime());
        encAsRepPart.setFlags(cc.getTicketFlags());
        encAsRepPart.setKey(cc.getKey());
        encAsRepPart.setRenewTill(cc.getRenewTill());
        encAsRepPart.setSname(cc.getServerName());
        encAsRepPart.setSrealm(cc.getServerName().getRealm());
        encAsRepPart.setStartTime(cc.getStartTime());
        TgtTicket tgtTicket = new TgtTicket(cc.getTicket(), encAsRepPart, cc.getClientName());
        return tgtTicket;
    }

    public Credential getCredentialFromFile(File ccFile) throws KrbException {
        CredentialCache cc;
        try {
            cc = this.resolveCredCache(ccFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to load armor cache file");
        }
        return cc.getCredentials().iterator().next();
    }

    public CredentialCache resolveCredCache(File ccacheFile) throws IOException {
        CredentialCache cc = new CredentialCache();
        cc.load(ccacheFile);
        return cc;
    }
}

