/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer.writer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.core.stream.serializer.writer.ASCIICompatibleXmlWriter;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;

final class UTF8XmlWriter
extends ASCIICompatibleXmlWriter {
    UTF8XmlWriter(OutputStream out) {
        super(out);
    }

    @Override
    public void setUnmappableCharacterHandler(UnmappableCharacterHandler unmappableCharacterHandler) {
    }

    @Override
    protected void writeNonASCIICharacter(int codePoint) throws IOException {
        if (codePoint < 2048) {
            this.writeByte((byte)(192 + (codePoint >> 6)));
            this.writeByte((byte)(128 + (codePoint & 0x3F)));
        } else if (codePoint < 65536) {
            this.writeByte((byte)(224 + (codePoint >> 12)));
            this.writeByte((byte)(128 + (codePoint >> 6 & 0x3F)));
            this.writeByte((byte)(128 + (codePoint & 0x3F)));
        } else {
            this.writeByte((byte)(240 + (codePoint >> 18)));
            this.writeByte((byte)(128 + (codePoint >> 12 & 0x3F)));
            this.writeByte((byte)(128 + (codePoint >> 6 & 0x3F)));
            this.writeByte((byte)(128 + (codePoint & 0x3F)));
        }
    }
}

