/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.ext.stax.BlobWriter;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.apache.axiom.util.stax.XMLStreamIOException;
import org.apache.axiom.util.stax.XMLStreamWriterWriter;

public class XMLStreamWriterUtils {
    public static void writeBase64(XMLStreamWriter writer, Blob blob) throws IOException, XMLStreamException {
        Base64EncodingWriterOutputStream out = new Base64EncodingWriterOutputStream(new XMLStreamWriterWriter(writer), 4096, true);
        try {
            blob.writeTo(out);
            out.close();
        }
        catch (XMLStreamIOException ex) {
            throw ex.getXMLStreamException();
        }
    }

    private static BlobWriter internalGetBlobWriter(XMLStreamWriter writer) {
        try {
            return (BlobWriter)writer.getProperty(BlobWriter.PROPERTY);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static BlobWriter getBlobWriter(final XMLStreamWriter writer) {
        BlobWriter blobWriter = XMLStreamWriterUtils.internalGetBlobWriter(writer);
        if (blobWriter == null) {
            return new BlobWriter(){

                @Override
                public void writeBlob(Blob blob, String contentID, boolean optimize) throws IOException, XMLStreamException {
                    XMLStreamWriterUtils.writeBase64(writer, blob);
                }

                @Override
                public void writeBlob(BlobProvider blobProvider, String contentID, boolean optimize) throws IOException, XMLStreamException {
                    XMLStreamWriterUtils.writeBase64(writer, blobProvider.getBlob());
                }
            };
        }
        return blobWriter;
    }

    public static void writeBlob(XMLStreamWriter writer, Blob blob, String contentID, boolean optimize) throws IOException, XMLStreamException {
        BlobWriter blobWriter = XMLStreamWriterUtils.internalGetBlobWriter(writer);
        if (blobWriter != null) {
            blobWriter.writeBlob(blob, contentID, optimize);
        } else {
            XMLStreamWriterUtils.writeBase64(writer, blob);
        }
    }

    public static void writeBlob(XMLStreamWriter writer, BlobProvider blobProvider, String contentID, boolean optimize) throws IOException, XMLStreamException {
        BlobWriter blobWriter = XMLStreamWriterUtils.internalGetBlobWriter(writer);
        if (blobWriter != null) {
            blobWriter.writeBlob(blobProvider, contentID, optimize);
        } else {
            XMLStreamWriterUtils.writeBase64(writer, blobProvider.getBlob());
        }
    }

    public static void writeDTD(XMLStreamWriter writer, String rootName, String publicId, String systemId, String internalSubset) throws XMLStreamException {
        StringBuilder buffer = new StringBuilder("<!DOCTYPE ");
        buffer.append(rootName);
        if (publicId != null) {
            buffer.append(" PUBLIC \"");
            buffer.append(publicId);
            buffer.append("\" \"");
            buffer.append(systemId);
            buffer.append("\"");
        } else if (systemId != null) {
            buffer.append(" SYSTEM \"");
            buffer.append(systemId);
            buffer.append("\"");
        }
        if (internalSubset != null) {
            buffer.append(" [");
            buffer.append(internalSubset);
            buffer.append("]");
        }
        buffer.append(">");
        writer.writeDTD(buffer.toString());
    }
}

