/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.deployment;

import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.AxisFault;

/**
 * this interface is used to inform deployment lifecycle realated events to
 * listners
 */
public interface DeploymentLifeCycleListener {

    /**
     * calls before creating the configuration context to do any initializing work.
     * @param axisConfig
     * @throws AxisFault
     */
    public void preDeploy(AxisConfiguration axisConfig) throws AxisFault;

    /**
     * calls after starting the configuration context to resume any activity.
     * @param configurationContext
     * @throws AxisFault
     */
    public void postDeploy(ConfigurationContext configurationContext) throws AxisFault;

}
