/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.AliasedMappedProperty;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class AnnotationChecks {
    private static final Package MAPPING_PACKAGE = Table.class.getPackage();

    AnnotationChecks() {
    }

    static <T extends Annotation> T getTypeAnnotation(Class<T> annotation, Class<?> annotatedClass) {
        T instance = annotatedClass.getAnnotation(annotation);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("@%s annotation was not found on %s", annotation.getSimpleName(), annotatedClass));
        }
        AnnotationChecks.validateAnnotations(annotatedClass, annotation);
        return instance;
    }

    private static void validateAnnotations(Class<?> clazz, Class<? extends Annotation> allowed) {
        HashSet<Annotation> classAnnotations = new HashSet<Annotation>();
        Collections.addAll(classAnnotations, clazz.getAnnotations());
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(classAnnotations, Collections.singleton(allowed));
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Cannot have both @%s and @%s on %s", allowed.getSimpleName(), invalid.getSimpleName(), clazz));
        }
    }

    static void validateAnnotations(String propertyName, Map<Class<? extends Annotation>, Annotation> annotations, Collection<? extends Class<? extends Annotation>> allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(annotations.values(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Annotation @%s is not allowed on property '%s'", invalid.getSimpleName(), propertyName));
        }
        AnnotationChecks.checkValidPrimaryKey(propertyName, annotations);
        AnnotationChecks.checkValidComputed(propertyName, annotations);
    }

    private static Class<? extends Annotation> validateAnnotations(Collection<Annotation> annotations, Collection<? extends Class<? extends Annotation>> allowed) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> actual = annotation.annotationType();
            if (!actual.getPackage().equals(MAPPING_PACKAGE) || allowed.contains(actual)) continue;
            return actual;
        }
        return null;
    }

    private static void checkValidPrimaryKey(String propertyName, Map<Class<? extends Annotation>, Annotation> annotations) {
        if (annotations.containsKey(PartitionKey.class) && annotations.containsKey(ClusteringColumn.class)) {
            throw new IllegalArgumentException(String.format("Property '%s' cannot be annotated with both @PartitionKey and @ClusteringColumn", propertyName));
        }
    }

    private static void checkValidComputed(String propertyName, Map<Class<? extends Annotation>, Annotation> annotations) {
        if (annotations.containsKey(Computed.class)) {
            Computed computed = (Computed)annotations.get(Computed.class);
            if (computed.value().isEmpty()) {
                throw new IllegalArgumentException(String.format("Property '%s': attribute 'value' of annotation @Computed is mandatory for computed properties", propertyName));
            }
            if (annotations.containsKey(Column.class)) {
                throw new IllegalArgumentException(String.format("Property '%s' cannot be annotated with both @Column and @Computed", propertyName));
            }
        }
    }

    static void validateOrder(List<AliasedMappedProperty> properties, String annotation) {
        for (int i = 0; i < properties.size(); ++i) {
            AliasedMappedProperty property = properties.get(i);
            int pos = property.mappedProperty.getPosition();
            if (pos == i) continue;
            throw new IllegalArgumentException(String.format("Invalid ordering value %d for annotation %s of property '%s', was expecting %d", pos, annotation, property.mappedProperty.getPropertyName(), i));
        }
    }
}

