/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class ByteLocaleConverter
extends DecimalLocaleConverter<Byte> {
    public static Builder builder() {
        return new Builder();
    }

    private ByteLocaleConverter(Byte defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected Byte parse(Object value, String pattern) throws ParseException {
        Object parsed = super.parse(value, pattern);
        if (((Number)parsed).longValue() != (long)((Number)parsed).byteValue()) {
            throw new ConversionException("Supplied number is not of type Byte: " + ((Number)parsed).longValue());
        }
        return ((Number)parsed).byteValue();
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, Byte> {
        @Override
        public ByteLocaleConverter get() {
            return new ByteLocaleConverter((Byte)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

