/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.MapStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class InterpolatorStringLookupTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTKEY2 = "TestKey2";
    private static final String TESTVAL = "TestValue";

    @BeforeAll
    public static void beforeAll() throws Throwable {
        System.setProperty(TESTKEY, TESTVAL);
        System.setProperty(TESTKEY2, TESTVAL);
    }

    @AfterAll
    public static void afterAll() throws Throwable {
        System.clearProperty(TESTKEY);
        System.clearProperty(TESTKEY2);
    }

    private void assertLookupNotEmpty(StringLookup lookup, String key) {
        String value = lookup.lookup(key);
        Assertions.assertNotNull((Object)value);
        Assertions.assertFalse((boolean)value.isEmpty());
        System.out.println(key + " = " + value);
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        InterpolatorStringLookup lookup = new InterpolatorStringLookup((StringLookup)MapStringLookup.on(map));
        String value = lookup.lookup(TESTKEY);
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assertions.assertNull((Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
    }

    @Test
    public void testLookupWithDefaultInterpolator() {
        InterpolatorStringLookup lookup = new InterpolatorStringLookup();
        String value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("env:PATH");
        Assertions.assertNotNull((Object)value);
        value = lookup.lookup("date:yyyy-MM-dd");
        Assertions.assertNotNull((Object)"No Date", (String)value);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        Assertions.assertEquals((Object)value, (Object)today);
        this.assertLookupNotEmpty((StringLookup)lookup, "java:version");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:runtime");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:vm");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:os");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:locale");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:hardware");
    }
}

