/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JSCode;
import org.mozilla.javascript.JSDescriptor;
import org.mozilla.javascript.JSFunction;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptJSCode;

public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class<?> targetExtends;
    private Class<?>[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnv) {
        if (compilerEnv == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnv;
        this.mainMethodClassName = "org.mozilla.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String className) {
        this.mainMethodClassName = className;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class<?> getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class<?> extendsClass) {
        this.targetExtends = extendsClass;
    }

    public Class<?>[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class<?>[] implementsClasses) {
        this.targetImplements = implementsClasses == null ? null : (Class[])implementsClasses.clone();
    }

    protected String makeAuxiliaryClassName(String mainClassName, String auxMarker) {
        return mainClassName + auxMarker;
    }

    public Object[] compileToClassFiles(String source, String sourceLocation, int lineno, String mainClassName) {
        Parser p = new Parser(this.compilerEnv);
        AstRoot ast = p.parse(source, sourceLocation, lineno);
        IRFactory irf = new IRFactory(this.compilerEnv, source);
        ScriptNode tree = irf.transformTree(ast);
        if (this.compilerEnv.isGeneratingSource()) {
            tree.setRawSource(source);
            tree.setRawSourceBounds(0, source.length());
        }
        irf = null;
        ast = null;
        p = null;
        Class<?> superClass = this.getTargetExtends();
        Class<?>[] interfaces = this.getTargetImplements();
        boolean isPrimary = interfaces == null && superClass == null;
        String scriptClassName = isPrimary ? mainClassName : this.makeAuxiliaryClassName(mainClassName, "1");
        Codegen codegen = new Codegen();
        codegen.setMainMethodClass(this.mainMethodClassName);
        JSDescriptor.Builder builder = new JSDescriptor.Builder();
        OptJSCode.BuilderEnv builderEnv = new OptJSCode.BuilderEnv(scriptClassName);
        byte[] scriptClassBytes = codegen.compileToClassFile(this.compilerEnv, builder, builderEnv, scriptClassName, tree, source, false);
        Object[] auxilaryClasses = this.buildDescriptorsAndMain(scriptClassName, builder);
        if (isPrimary) {
            Object[] result = new Object[auxilaryClasses.length + 2];
            System.arraycopy(auxilaryClasses, 0, result, 2, auxilaryClasses.length);
            result[0] = scriptClassName;
            result[1] = scriptClassBytes;
            return result;
        }
        int functionCount = tree.getFunctionCount();
        HashMap<String, Integer> functionNames = new HashMap<String, Integer>();
        for (int i = 0; i != functionCount; ++i) {
            FunctionNode ofn = tree.getFunctionNode(i);
            String name = ofn.getName();
            if (name == null || name.length() == 0) continue;
            functionNames.put(name, ofn.getParamCount());
        }
        if (superClass == null) {
            superClass = ScriptRuntime.ObjectClass;
        }
        byte[] mainClassBytes = JavaAdapter.createAdapterCode(functionNames, mainClassName, superClass, interfaces, scriptClassName);
        Object[] result = new Object[auxilaryClasses.length + 4];
        System.arraycopy(auxilaryClasses, 0, result, 4, auxilaryClasses.length);
        result[0] = mainClassName;
        result[1] = mainClassBytes;
        result[2] = scriptClassName;
        result[3] = scriptClassBytes;
        return result;
    }

    private Object[] buildDescriptorsAndMain(String mainClassName, JSDescriptor.Builder builder) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        String mainName = mainClassName + "Main";
        ClassFileWriter cfw = new ClassFileWriter(mainName, "java.lang.Object", "");
        ArrayList builders = new ArrayList();
        this.buildDescriptor(cfw, builder, classes, builders);
        cfw.startMethod("<clinit>", "()V", (short)8);
        cfw.addLoadConstant(builders.size());
        cfw.add(189, "org/mozilla/javascript/JSDescriptor");
        for (JSDescriptor.Builder<?> b : builders) {
            int index = ((OptJSCode.Builder)b.code).index;
            int parent = b.parent == null ? 0 : ((OptJSCode.Builder)b.parent.code).index;
            this.populateDescriptorEntry(cfw, index, parent);
        }
        cfw.add(179, mainClassName, "_descriptors", "[Lorg/mozilla/javascript/JSDescriptor;");
        cfw.add(177);
        cfw.stopMethod(0);
        cfw.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        cfw.add(187, "org.mozilla.javascript.JSScript");
        cfw.add(89);
        cfw.add(178, mainClassName, "_descriptors", "[Lorg/mozilla/javascript/JSDescriptor;");
        cfw.addLoadConstant(0);
        cfw.add(50);
        cfw.add(1);
        cfw.addInvoke(183, "org/mozilla/javascript/JSScript", "<init>", "(Lorg/mozilla/javascript/JSDescriptor;Lorg/mozilla/javascript/Scriptable;)V");
        cfw.add(42);
        cfw.addInvoke(184, this.mainMethodClassName, "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        cfw.add(177);
        cfw.stopMethod(1);
        Object[] result = new Object[classes.size() * 2 + 2];
        int count = 0;
        result[count++] = mainName;
        result[count++] = cfw.toByteArray();
        for (Map.Entry<String, byte[]> e : classes.entrySet()) {
            result[count++] = e.getKey();
            result[count++] = e.getValue();
        }
        return result;
    }

    private void buildDescriptor(ClassFileWriter cfw, JSDescriptor.Builder builder, Map<String, byte[]> classes, List<JSDescriptor.Builder<?>> builders) {
        int p;
        builders.add(builder);
        cfw.startMethod("init" + this.functionId(builder), "(Lorg/mozilla/javascript/JSDescriptor;)Lorg/mozilla/javascript/JSDescriptor;", (short)8);
        cfw.add(187, "org.mozilla.javascript.JSDescriptor");
        cfw.add(89);
        this.buildCode(cfw, builder.code, classes);
        this.buildCode(cfw, builder.constructor, classes);
        cfw.addALoad(0);
        cfw.addLoadConstant(builder.paramAndVarNames.length);
        cfw.add(189, "java/lang/String");
        if (builder.paramAndVarNames.length > 0) {
            cfw.addLoadConstant(0);
            cfw.addIStore(2);
            for (p = 0; p < builder.paramAndVarNames.length; ++p) {
                cfw.add(89);
                cfw.addILoad(2);
                cfw.addLoadConstant(builder.paramAndVarNames[p]);
                cfw.add(83);
                cfw.add(132, 2, 1);
            }
        }
        cfw.addLoadConstant(builder.paramIsConst.length);
        cfw.add(188, 4);
        if (builder.paramIsConst.length > 0) {
            cfw.addLoadConstant(0);
            cfw.addIStore(2);
            for (p = 0; p < builder.paramAndVarNames.length; ++p) {
                cfw.add(89);
                cfw.addILoad(2);
                cfw.add(builder.paramIsConst[p] ? 4 : 3);
                cfw.add(84);
                cfw.add(132, 2, 1);
            }
        }
        cfw.add(builder.isStrict ? 4 : 3);
        cfw.add(builder.isScript ? 4 : 3);
        cfw.add(builder.isTopLevel ? 4 : 3);
        cfw.add(builder.isES6Generator ? 4 : 3);
        cfw.add(builder.isShorthand ? 4 : 3);
        cfw.add(builder.hasPrototype ? 4 : 3);
        cfw.add(builder.hasLexicalThis ? 4 : 3);
        cfw.add(builder.isEvalFunction ? 4 : 3);
        cfw.add(builder.hasRestArg ? 4 : 3);
        cfw.addLoadConstant(builder.sourceFile);
        cfw.addLoadConstant(builder.rawSource);
        cfw.addLoadConstant(builder.rawSourceStart);
        cfw.addLoadConstant(builder.rawSourceEnd);
        if (builder.name == null) {
            cfw.add(1);
        } else {
            cfw.addLoadConstant(builder.name);
        }
        cfw.addLoadConstant(builder.languageVersion);
        cfw.addLoadConstant(builder.paramAndVarCount);
        cfw.addLoadConstant(builder.paramCount);
        cfw.addLoadConstant(builder.arity);
        cfw.add(builder.hasDefaultParameters ? 4 : 3);
        cfw.add(builder.requiresActivationFrame ? 4 : 3);
        cfw.add(builder.requiresArgumentObject ? 4 : 3);
        cfw.add(builder.declaredAsFunctionExpression ? 4 : 3);
        cfw.add(1);
        cfw.add(1);
        cfw.addLoadConstant(builder.functionType);
        String type = MethodType.methodType(Void.TYPE, JSDescriptor.class.getConstructors()[0].getParameterTypes()).toMethodDescriptorString();
        cfw.addInvoke(183, "org.mozilla.javascript.JSDescriptor", "<init>", type);
        cfw.addAStore(1);
        cfw.addALoad(1);
        cfw.add(89);
        cfw.addLoadConstant(builder.nestedFunctions.size());
        cfw.add(189, "org/mozilla/javascript/JSDescriptor");
        if (builder.nestedFunctions.size() > 0) {
            cfw.addLoadConstant(0);
            cfw.addIStore(2);
            for (JSDescriptor.Builder<JSFunction> child : builder.nestedFunctions) {
                cfw.add(89);
                cfw.addILoad(2);
                cfw.addALoad(1);
                cfw.addInvoke(184, cfw.getClassName(), "init" + this.functionId(child), "(Lorg/mozilla/javascript/JSDescriptor;)Lorg/mozilla/javascript/JSDescriptor;");
                cfw.add(83);
                cfw.add(132, 2, 1);
            }
        }
        cfw.addInvoke(184, "org.mozilla.javascript.optimizer.OptRuntime", "listOf", "([Ljava/lang/Object;)Ljava/util/List;");
        cfw.add(181, "org.mozilla.javascript.JSDescriptor", "nestedFunctions", "Ljava/util/List;");
        cfw.add(176);
        cfw.stopMethod(2);
        for (JSDescriptor.Builder<JSFunction> child : builder.nestedFunctions) {
            this.buildDescriptor(cfw, child, classes, builders);
        }
    }

    private void buildCode(ClassFileWriter cfw, JSCode.Builder builder, Map<String, byte[]> classes) {
        if (builder instanceof JSCode.NullBuilder) {
            cfw.add(1);
        } else {
            OptJSCode.Builder code = (OptJSCode.Builder)builder;
            code.buildByteCode(cfw);
            classes.put(code.getClassName(), code.getClassBytes());
        }
    }

    private void populateDescriptorEntry(ClassFileWriter cfw, int index, int parent) {
        cfw.add(89);
        cfw.add(89);
        cfw.addLoadConstant(parent);
        cfw.add(50);
        cfw.addInvoke(184, cfw.getClassName(), "init" + index, "(Lorg/mozilla/javascript/JSDescriptor;)Lorg/mozilla/javascript/JSDescriptor;");
        cfw.addLoadConstant(index);
        cfw.add(95);
        cfw.add(83);
    }

    private int functionId(JSDescriptor.Builder builder) {
        OptJSCode.Builder code = (OptJSCode.Builder)builder.code;
        return code.index;
    }
}

