/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;

public class SessionSendContinuationMessage_V2
extends SessionSendContinuationMessage {
    private long correlationID;

    public SessionSendContinuationMessage_V2() {
    }

    public SessionSendContinuationMessage_V2(Message message, byte[] body, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super(message, body, continues, requiresResponse, messageBodySize, handler);
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + 8;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readableBytes() >= 8 ? buffer.readLong() : -1L;
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void setCorrelationID(long correlationID) {
        this.correlationID = correlationID;
    }

    @Override
    public boolean isResponseAsync() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.correlationID);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", continues=" + this.continues);
        sb.append(", message=" + String.valueOf(this.message));
        sb.append(", messageBodySize=" + this.messageBodySize);
        sb.append(", requiresResponse=" + this.requiresResponse);
        sb.append(", correlationID=" + this.correlationID);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendContinuationMessage_V2)) {
            return false;
        }
        SessionSendContinuationMessage_V2 other = (SessionSendContinuationMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

