/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

public final class ThetaUtil {
    public static final int MIN_LG_NOM_LONGS = 4;
    public static final int MAX_LG_NOM_LONGS = 26;
    public static final double REBUILD_THRESHOLD = 0.9375;
    public static final double RESIZE_THRESHOLD = 0.5;
    public static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    public static final int MIN_LG_ARR_LONGS = 5;

    private ThetaUtil() {
    }

    public static int startingSubMultiple(int lgTarget, int lgRF, int lgMin) {
        return lgTarget <= lgMin ? lgMin : (lgRF == 0 ? lgTarget : (lgTarget - lgMin) % lgRF + lgMin);
    }

    public static int checkNomLongs(int nomLongs) {
        int lgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomLongs));
        if (lgNomLongs > 26 || lgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomLongs);
        }
        return lgNomLongs;
    }
}

