package org.apache.torque.oid;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.adapter.Adapter;

/**
 * This generator works with databases that have an sql syntax that
 * allows the retrieval of the last id used to insert a row for a
 * Connection.
 *
 * @author <a href="mailto:jmcnally@collab.net">John D. McNally</a>
 * @version $Id: AutoIncrementIdGenerator.java 1388656 2012-09-21 19:59:16Z tfischer $
 */
public class AutoIncrementIdGenerator extends AbstractIdGenerator
{
    /**
     * Creates an IdGenerator which will work with the specified database.
     *
     * @param adapter the adapter that knows the correct sql syntax.
     * @param databaseName The name of the databaseName to find the correct
     *        schema.
     */
    public AutoIncrementIdGenerator(
            final Adapter adapter,
            final String databaseName)
    {
        super(adapter, databaseName);
    }

    /**
     * A flag to determine the timing of the id generation
     *
     * @return a <code>boolean</code> value
     */
    @Override
    public boolean isPriorToInsert()
    {
        return false;
    }

    /**
     * A flag to determine the timing of the id generation
     *
     * @return a <code>boolean</code> value
     */
    @Override
    public boolean isPostInsert()
    {
        return true;
    }

    /**
     * A flag to determine whether a Connection is required to
     * generate an id.
     *
     * @return a <code>boolean</code> value
     */
    @Override
    public final boolean isConnectionRequired()
    {
        return true;
    }
}
