/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class ProcessResourceCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public ProcessResourceCommand(CommitResourceCommand commitCommand) {
        this.m_commitCommand = commitCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        this.addRollback(new RollbackCommitAction(session));
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        HashMap<String, AbstractInfo> expectedResources = new HashMap<String, AbstractInfo>();
        AbstractInfo[] resourceInfos = source.getResourceInfos();
        for (int i = 0; i < resourceInfos.length; ++i) {
            AbstractInfo resourceInfo = resourceInfos[i];
            if (resourceInfo.isMissing()) continue;
            expectedResources.put(resourceInfo.getPath(), resourceInfo);
        }
        try {
            while (!expectedResources.isEmpty()) {
                AbstractInfo jarEntry = source.getNextEntry();
                if (jarEntry == null) {
                    throw new DeploymentException(463, "Expected more resources in the stream: " + expectedResources.keySet());
                }
                String name = jarEntry.getPath();
                ResourceInfoImpl resourceInfo = (ResourceInfoImpl)expectedResources.remove(name);
                if (resourceInfo == null) {
                    throw new DeploymentException(463, "Resource '" + name + "' is not described in the manifest.");
                }
                if (!resourceInfo.isProcessedResource()) {
                    session.getLog().log(3, "Ignoring non-processed resource: " + resourceInfo.getPath());
                    continue;
                }
                ServiceReference ref = source.getResourceProcessor(name);
                if (ref == null) {
                    throw new DeploymentException(464, "No resource processor for resource: '" + name + "'");
                }
                if (!this.isValidCustomizer(session, ref)) {
                    throw new DeploymentException(458, "Resource processor for resource '" + name + "' belongs to foreign deployment package");
                }
                ResourceProcessor resourceProcessor = (ResourceProcessor)context.getService(ref);
                if (resourceProcessor == null) {
                    throw new DeploymentException(464, "No resource processor for resource: '" + name + "'");
                }
                try {
                    if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                        resourceProcessor.begin(session);
                    }
                    resourceProcessor.process(name, source.getCurrentEntryStream());
                }
                catch (ResourceProcessorException rpe) {
                    if (rpe.getCode() != 461) throw new DeploymentException(463, "Error while processing resource '" + name + "'", rpe);
                    throw new DeploymentException(461, "Sharing violation while processing resource '" + name + "'", rpe);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException(463, "Problem while reading stream", e);
        }
    }

    private boolean isValidCustomizer(DeploymentSessionImpl session, ServiceReference ref) {
        String serviceOwnerSymName;
        if (session.getConfiguration().isAllowForeignCustomizers()) {
            return ref != null;
        }
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        return source.getBundleInfoByName(serviceOwnerSymName = ref.getBundle().getSymbolicName()) != null;
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl session) {
            this.m_session = session;
        }

        protected void doRun() {
            ProcessResourceCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

