/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal;

import java.util.ArrayList;
import org.apache.felix.http.base.internal.AbstractActivator;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.tracker.FilterTracker;
import org.apache.felix.http.whiteboard.internal.tracker.HttpContextTracker;
import org.apache.felix.http.whiteboard.internal.tracker.ListenersTracker;
import org.apache.felix.http.whiteboard.internal.tracker.ServletTracker;
import org.osgi.util.tracker.ServiceTracker;

public final class WhiteboardActivator
extends AbstractActivator {
    private final ArrayList<ServiceTracker<?, ?>> trackers = new ArrayList();

    @Override
    protected void doStart() throws Exception {
        ExtenderManager manager = new ExtenderManager();
        this.addTracker(new HttpContextTracker(this.getBundleContext(), manager));
        this.addTracker(new FilterTracker(this.getBundleContext(), manager));
        this.addTracker(new ServletTracker(this.getBundleContext(), manager));
        this.addTracker(new ListenersTracker(this.getBundleContext(), manager));
        SystemLogger.info("Apachde Felix Http Whiteboard Service started");
    }

    private void addTracker(ServiceTracker<?, ?> tracker) {
        this.trackers.add(tracker);
        tracker.open();
    }

    @Override
    protected void doStop() throws Exception {
        for (ServiceTracker<?, ?> tracker : this.trackers) {
            tracker.close();
        }
        this.trackers.clear();
        SystemLogger.info("Apachde Felix Http Whiteboard Service stopped");
    }
}

