/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class Instance
implements HandlerConfiguration {
    private String m_type;
    private List m_conf = new ArrayList();

    public Instance(String type) {
        this.m_type = type;
    }

    public Instance addProperty(String name, String value) {
        Element elem = new Element("property", "");
        this.m_conf.add(elem);
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("value", value));
        return this;
    }

    public Instance addProperty(String name, List values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "list"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            Element e = new Element("property", "");
            elem.addElement(e);
            if (!(obj instanceof String)) {
                throw new UnsupportedOperationException("Complex properties are not supported yet");
            }
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public Instance addProperty(String name, String[] values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "array"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.length; ++i) {
            String obj = values[i];
            Element e = new Element("property", "");
            elem.addElement(e);
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public Instance addProperty(String name, Vector values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "vector"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            Element e = new Element("property", "");
            elem.addElement(e);
            if (!(obj instanceof String)) {
                throw new UnsupportedOperationException("Complex properties are not supported yet");
            }
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public Instance addProperty(String name, Map values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "map"));
        this.m_conf.add(elem);
        Set entries = values.entrySet();
        for (Map.Entry entry : entries) {
            Element e = new Element("property", "");
            elem.addElement(e);
            String n = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                e.addAttribute(new Attribute("name", n));
                e.addAttribute(new Attribute("value", v.toString()));
                continue;
            }
            throw new UnsupportedOperationException("Complex properties are not supported yet");
        }
        return this;
    }

    public Instance addProperty(String name, Dictionary values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "dictionary"));
        this.m_conf.add(elem);
        Enumeration e = values.keys();
        while (e.hasMoreElements()) {
            Element el = new Element("property", "");
            elem.addElement(el);
            String n = (String)e.nextElement();
            Object v = values.get(n);
            if (v instanceof String) {
                el.addAttribute(new Attribute("name", n));
                el.addAttribute(new Attribute("value", v.toString()));
                continue;
            }
            throw new UnsupportedOperationException("Complex properties are not supported yet");
        }
        return this;
    }

    private void ensureValidity() {
        if (this.m_type == null) {
            throw new IllegalStateException("Invalid containted instance configuration : the component type is not set");
        }
    }

    public Element getElement() {
        this.ensureValidity();
        Element instance = new Element("instance", "");
        instance.addAttribute(new Attribute("component", this.m_type));
        for (int i = 0; i < this.m_conf.size(); ++i) {
            Element elem = (Element)this.m_conf.get(i);
            instance.addElement(elem);
        }
        return instance;
    }
}

