/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl;

import java.util.List;
import org.apache.felix.useradmin.impl.AuthorizationImpl;
import org.apache.felix.useradmin.impl.EventDispatcher;
import org.apache.felix.useradmin.impl.RoleChangeListener;
import org.apache.felix.useradmin.impl.RoleRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.service.useradmin.UserAdminEvent;

public class UserAdminImpl
implements ServiceFactory,
UserAdmin,
RoleChangeListener {
    private final RoleRepository m_roleRepository;
    private final EventDispatcher m_eventDispatcher;
    private volatile ServiceReference m_serviceRef;

    public UserAdminImpl(RoleRepository roleRepository, EventDispatcher eventDispatcher) {
        if (roleRepository == null) {
            throw new IllegalArgumentException("RoleRepository cannot be null!");
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException("EventDispatcher cannot be null!");
        }
        this.m_roleRepository = roleRepository;
        this.m_eventDispatcher = eventDispatcher;
        this.m_roleRepository.addRoleChangeListener(this);
    }

    @Override
    public Role createRole(String name, int type) {
        return this.m_roleRepository.addRole(name, type);
    }

    @Override
    public Authorization getAuthorization(User user) {
        return new AuthorizationImpl(user, this.m_roleRepository);
    }

    @Override
    public Role getRole(String name) {
        return this.m_roleRepository.getRoleByName(name);
    }

    @Override
    public Role[] getRoles(String filter) throws InvalidSyntaxException {
        List roles;
        if (filter != null && !"".equals(filter.trim())) {
            FrameworkUtil.createFilter((String)filter);
        }
        if ((roles = this.m_roleRepository.getRoles(filter)).isEmpty()) {
            return null;
        }
        return roles.toArray(new Role[roles.size()]);
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.m_serviceRef = registration.getReference();
        return this;
    }

    @Override
    public User getUser(String key, String value) {
        Role foundRole;
        User result = null;
        List roles = this.m_roleRepository.getRoles(key, value);
        if (roles.size() == 1 && (foundRole = (Role)roles.get(0)).getType() == 1) {
            result = (User)foundRole;
        }
        return result;
    }

    @Override
    public void propertyAdded(Role role, Object key, Object value) {
        this.m_eventDispatcher.dispatch(this.createUserAdminEvent(2, role));
    }

    @Override
    public void propertyChanged(Role role, Object key, Object oldValue, Object newValue) {
        this.m_eventDispatcher.dispatch(this.createUserAdminEvent(2, role));
    }

    @Override
    public void propertyRemoved(Role role, Object key) {
        this.m_eventDispatcher.dispatch(this.createUserAdminEvent(2, role));
    }

    @Override
    public boolean removeRole(String name) {
        return this.m_roleRepository.removeRole(name);
    }

    @Override
    public void roleAdded(Role role) {
        this.m_eventDispatcher.dispatch(this.createUserAdminEvent(1, role));
    }

    @Override
    public void roleRemoved(Role role) {
        this.m_eventDispatcher.dispatch(this.createUserAdminEvent(4, role));
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    private UserAdminEvent createUserAdminEvent(int type, Role role) {
        return new UserAdminEvent(this.m_serviceRef, type, role);
    }
}

