/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.refresh;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.refresh.RefreshHandler;

@Internal
public class ContinuousRefreshHandler
implements RefreshHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String executionTarget;
    private final String clusterId;
    private final String jobId;
    @Nullable
    private final String restorePath;

    public ContinuousRefreshHandler(String executionTarget, String clusterId, String jobId) {
        this.executionTarget = executionTarget;
        this.clusterId = clusterId;
        this.jobId = jobId;
        this.restorePath = null;
    }

    public ContinuousRefreshHandler(String executionTarget, String clusterId, String jobId, String restorePath) {
        this.executionTarget = executionTarget;
        this.clusterId = clusterId;
        this.jobId = jobId;
        this.restorePath = restorePath;
    }

    public String getExecutionTarget() {
        return this.executionTarget;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Optional<String> getRestorePath() {
        return Optional.ofNullable(this.restorePath);
    }

    @Override
    public String asSummaryString() {
        return String.format("{\n executionTarget=%s,\n clusterId=%s,\n jobId=%s%s\n}", this.executionTarget, this.clusterId, this.jobId, this.restorePath == null ? "" : ",\n restorePath=" + this.restorePath);
    }
}

