/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public final class ArrayOfStringArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> actualDataTypes = callContext.getArgumentDataTypes();
        DataType actualType = actualDataTypes.get(argumentPos);
        if (!actualType.getLogicalType().getTypeRoot().equals((Object)LogicalTypeRoot.ARRAY)) {
            return callContext.fail(throwOnFailure, "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)", actualDataTypes.toArray());
        }
        DataType elementDataType = ((CollectionDataType)actualType).getElementDataType();
        Optional<DataType> closedDataType = StrategyUtils.findDataType(callContext, throwOnFailure, elementDataType, LogicalTypeRoot.VARCHAR, Boolean.TRUE);
        if (closedDataType.isPresent()) {
            return Optional.of(actualType);
        }
        return callContext.fail(throwOnFailure, "The input argument should be ARRAY<STRING>", actualDataTypes.toArray());
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("ARRAY<STRING>");
    }
}

