/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.utils;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.util.Preconditions;

@Internal
public final class CastCallContext
implements CallContext {
    private final CallContext originalContext;
    @Nullable
    private final DataType outputDataType;
    private List<DataType> expectedArguments;

    public CastCallContext(CallContext originalContext, @Nullable DataType outputDataType) {
        this.originalContext = originalContext;
        this.expectedArguments = originalContext.getArgumentDataTypes();
        this.outputDataType = outputDataType;
    }

    public void setExpectedArguments(List<DataType> expectedArguments) {
        Preconditions.checkArgument((this.expectedArguments.size() == expectedArguments.size() ? 1 : 0) != 0);
        this.expectedArguments = expectedArguments;
    }

    @Override
    public DataTypeFactory getDataTypeFactory() {
        return this.originalContext.getDataTypeFactory();
    }

    @Override
    public FunctionDefinition getFunctionDefinition() {
        return this.originalContext.getFunctionDefinition();
    }

    @Override
    public boolean isArgumentLiteral(int pos) {
        if (this.isCast(pos)) {
            return false;
        }
        return this.originalContext.isArgumentLiteral(pos);
    }

    @Override
    public boolean isArgumentNull(int pos) {
        return this.originalContext.isArgumentNull(pos);
    }

    @Override
    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isCast(pos)) {
            return Optional.empty();
        }
        return this.originalContext.getArgumentValue(pos, clazz);
    }

    @Override
    public Optional<TableSemantics> getTableSemantics(int pos) {
        return this.originalContext.getTableSemantics(pos);
    }

    @Override
    public String getName() {
        return this.originalContext.getName();
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return this.expectedArguments;
    }

    @Override
    public Optional<DataType> getOutputDataType() {
        return Optional.ofNullable(this.outputDataType);
    }

    @Override
    public boolean isGroupedAggregation() {
        return this.originalContext.isGroupedAggregation();
    }

    private boolean isCast(int pos) {
        LogicalType expectedType;
        LogicalType originalType = this.originalContext.getArgumentDataTypes().get(pos).getLogicalType();
        return !LogicalTypeCasts.supportsAvoidingCast(originalType, expectedType = this.expectedArguments.get(pos).getLogicalType());
    }
}

