/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
@Deprecated
public final class LegacyTypeInfoDataTypeConverter {
    private static final Map<TypeInformation<?>, DataType> typeInfoDataTypeMap = new HashMap();
    private static final Map<DataType, TypeInformation<?>> dataTypeTypeInfoMap = new HashMap();

    private static void addMapping(TypeInformation<?> typeInfo, DataType dataType) {
        Preconditions.checkArgument((!typeInfoDataTypeMap.containsKey(typeInfo) ? 1 : 0) != 0);
        typeInfoDataTypeMap.put(typeInfo, dataType);
        dataTypeTypeInfoMap.put(dataType, typeInfo);
    }

    public static DataType toDataType(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof TimeIndicatorTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToTimeAttributeType((TimeIndicatorTypeInfo)typeInfo);
        }
        DataType foundDataType = typeInfoDataTypeMap.get(typeInfo);
        if (foundDataType != null) {
            return foundDataType;
        }
        if (typeInfo instanceof RowTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToRowType((RowTypeInfo)typeInfo);
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToArrayType(typeInfo.getTypeClass(), ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.ARRAY, typeInfo);
        }
        if (typeInfo instanceof MultisetTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToMultisetType(((MultisetTypeInfo)typeInfo).getElementTypeInfo());
        }
        if (typeInfo instanceof MapTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToMapType((MapTypeInfo)typeInfo);
        }
        if (typeInfo instanceof CompositeType || LegacyTypeInfoDataTypeConverter.isRowData(typeInfo)) {
            return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.STRUCTURED_TYPE, typeInfo);
        }
        return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.RAW, typeInfo);
    }

    public static TypeInformation<?> toLegacyTypeInfo(DataType dataType) {
        if (LegacyTypeInfoDataTypeConverter.canConvertToTimeAttributeTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToTimeAttributeTypeInfo(dataType.getLogicalType());
        }
        TypeInformation<?> foundTypeInfo = dataTypeTypeInfoMap.get(((DataType)dataType.nullable()).bridgedTo(ExtractionUtils.primitiveToWrapper(dataType.getConversionClass())));
        if (foundTypeInfo != null) {
            return foundTypeInfo;
        }
        LogicalType logicalType = dataType.getLogicalType();
        if (logicalType.is(LogicalTypeRoot.DECIMAL)) {
            return Types.BIG_DEC;
        }
        if (logicalType.is(LogicalTypeRoot.CHAR)) {
            return Types.STRING;
        }
        if (logicalType.is(LogicalTypeRoot.VARCHAR)) {
            return Types.STRING;
        }
        if (logicalType.is(LogicalTypeRoot.VARIANT)) {
            return Types.VARIANT;
        }
        if (logicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && dataType.getConversionClass() == Timestamp.class) {
            return Types.SQL_TIMESTAMP;
        }
        if (logicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && dataType.getConversionClass() == LocalDateTime.class) {
            return Types.LOCAL_DATE_TIME;
        }
        if (logicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) && dataType.getConversionClass() == Timestamp.class) {
            return Types.SQL_TIMESTAMP;
        }
        if (logicalType.is(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE) && dataType.getConversionClass() == LocalTime.class) {
            return Types.LOCAL_TIME;
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToLegacyTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToLegacyTypeInfo(dataType);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToRowTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToRowTypeInfo((FieldsDataType)dataType);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToObjectArrayTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToObjectArrayTypeInfo((CollectionDataType)dataType);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToMultisetTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToMultisetTypeInfo((CollectionDataType)dataType);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToMapTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToMapTypeInfo((KeyValueDataType)dataType);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToRawTypeInfo(dataType)) {
            return LegacyTypeInfoDataTypeConverter.convertToRawTypeInfo(dataType);
        }
        throw new TableException(String.format("Unsupported conversion from data type '%s' (conversion class: %s) to type information. Only data types that originated from type information fully support a reverse conversion.", dataType, dataType.getConversionClass().getName()));
    }

    private static DataType createLegacyType(LogicalTypeRoot typeRoot, TypeInformation<?> typeInfo) {
        return new AtomicDataType(new LegacyTypeInformationType(typeRoot, typeInfo)).bridgedTo(typeInfo.getTypeClass());
    }

    private static DataType convertToTimeAttributeType(TimeIndicatorTypeInfo timeIndicatorTypeInfo) {
        if (timeIndicatorTypeInfo.isEventTime()) {
            return new AtomicDataType(new TimestampType(true, TimestampKind.ROWTIME, 3)).bridgedTo((Class)Timestamp.class);
        }
        return new AtomicDataType(new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3)).bridgedTo((Class)Instant.class);
    }

    private static boolean canConvertToTimeAttributeTypeInfo(DataType dataType) {
        if (dataType.getLogicalType().is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return ((TimestampType)dataType.getLogicalType()).getKind() != TimestampKind.REGULAR;
        }
        if (dataType.getLogicalType().is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return ((LocalZonedTimestampType)dataType.getLogicalType()).getKind() != TimestampKind.REGULAR;
        }
        return false;
    }

    private static TypeInformation<?> convertToTimeAttributeTypeInfo(LogicalType type) {
        if (LogicalTypeChecks.isRowtimeAttribute(type)) {
            return TimeIndicatorTypeInfo.ROWTIME_INDICATOR;
        }
        return TimeIndicatorTypeInfo.PROCTIME_INDICATOR;
    }

    private static DataType convertToRowType(RowTypeInfo rowTypeInfo) {
        String[] fieldNames = rowTypeInfo.getFieldNames();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, rowTypeInfo.getArity()).mapToObj(i -> {
            DataType fieldType = LegacyTypeInfoDataTypeConverter.toDataType(rowTypeInfo.getTypeAt(i));
            return DataTypes.FIELD(fieldNames[i], fieldType);
        }).toArray(DataTypes.Field[]::new);
        return (DataType)DataTypes.ROW(fields).bridgedTo(Row.class);
    }

    private static boolean canConvertToRowTypeInfo(DataType dataType) {
        return dataType.getLogicalType().is(LogicalTypeRoot.ROW) && dataType.getConversionClass().equals(Row.class) && ((RowType)dataType.getLogicalType()).getFields().stream().noneMatch(f -> f.getDescription().isPresent());
    }

    private static TypeInformation<?> convertToRowTypeInfo(FieldsDataType fieldsDataType) {
        RowType rowType = (RowType)fieldsDataType.getLogicalType();
        String[] fieldNames = (String[])rowType.getFields().stream().map(RowType.RowField::getName).toArray(String[]::new);
        TypeInformation[] fieldTypes = (TypeInformation[])fieldsDataType.getChildren().stream().map(LegacyTypeInfoDataTypeConverter::toLegacyTypeInfo).toArray(TypeInformation[]::new);
        return Types.ROW_NAMED((String[])fieldNames, (TypeInformation[])fieldTypes);
    }

    private static DataType convertToArrayType(Class<?> arrayClass, TypeInformation<?> elementTypeInfo) {
        return (DataType)DataTypes.ARRAY(LegacyTypeInfoDataTypeConverter.toDataType(elementTypeInfo)).bridgedTo(arrayClass);
    }

    private static boolean canConvertToObjectArrayTypeInfo(DataType dataType) {
        return dataType.getLogicalType().is(LogicalTypeRoot.ARRAY) && dataType.getConversionClass().isArray();
    }

    private static TypeInformation<?> convertToObjectArrayTypeInfo(CollectionDataType collectionDataType) {
        return ObjectArrayTypeInfo.getInfoFor(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(collectionDataType.getElementDataType()));
    }

    private static DataType convertToMultisetType(TypeInformation<?> elementTypeInfo) {
        return (DataType)DataTypes.MULTISET(LegacyTypeInfoDataTypeConverter.toDataType(elementTypeInfo)).bridgedTo(Map.class);
    }

    private static boolean canConvertToMultisetTypeInfo(DataType dataType) {
        return dataType.getLogicalType().is(LogicalTypeRoot.MULTISET) && dataType.getConversionClass() == Map.class;
    }

    private static TypeInformation<?> convertToMultisetTypeInfo(CollectionDataType collectionDataType) {
        return new MultisetTypeInfo(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(collectionDataType.getElementDataType()));
    }

    private static DataType convertToMapType(MapTypeInfo<?, ?> typeInfo) {
        return (DataType)DataTypes.MAP(LegacyTypeInfoDataTypeConverter.toDataType(typeInfo.getKeyTypeInfo()), LegacyTypeInfoDataTypeConverter.toDataType(typeInfo.getValueTypeInfo())).bridgedTo(Map.class);
    }

    private static boolean canConvertToMapTypeInfo(DataType dataType) {
        return dataType.getLogicalType().is(LogicalTypeRoot.MAP) && dataType.getConversionClass() == Map.class;
    }

    private static TypeInformation<?> convertToMapTypeInfo(KeyValueDataType dataType) {
        return Types.MAP(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(dataType.getKeyDataType()), LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(dataType.getValueDataType()));
    }

    private static boolean canConvertToLegacyTypeInfo(DataType dataType) {
        return dataType.getLogicalType() instanceof LegacyTypeInformationType;
    }

    private static TypeInformation<?> convertToLegacyTypeInfo(DataType dataType) {
        return ((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
    }

    private static boolean canConvertToRawTypeInfo(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        return type.is(LogicalTypeRoot.RAW) && dataType.getConversionClass() == type.getDefaultConversion();
    }

    private static TypeInformation<?> convertToRawTypeInfo(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (type instanceof TypeInformationRawType) {
            return ((TypeInformationRawType)dataType.getLogicalType()).getTypeInformation();
        }
        return new GenericTypeInfo(type.getDefaultConversion());
    }

    private static boolean isRowData(TypeInformation<?> typeInfo) {
        if (!(typeInfo instanceof DataTypeQueryable)) {
            return false;
        }
        DataType dataType = ((DataTypeQueryable)typeInfo).getDataType();
        return dataType.getConversionClass() == RowData.class;
    }

    private LegacyTypeInfoDataTypeConverter() {
    }

    static {
        LegacyTypeInfoDataTypeConverter.addMapping(Types.STRING, (DataType)DataTypes.STRING().bridgedTo(String.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BOOLEAN, (DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BYTE, (DataType)DataTypes.TINYINT().bridgedTo(Byte.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SHORT, (DataType)DataTypes.SMALLINT().bridgedTo(Short.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.INT, (DataType)DataTypes.INT().bridgedTo(Integer.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LONG, (DataType)DataTypes.BIGINT().bridgedTo(Long.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.FLOAT, (DataType)DataTypes.FLOAT().bridgedTo(Float.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.DOUBLE, (DataType)DataTypes.DOUBLE().bridgedTo(Double.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BIG_DEC, LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.DECIMAL, Types.BIG_DEC));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_DATE, (DataType)DataTypes.DATE().bridgedTo(LocalDate.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_TIME, (DataType)DataTypes.TIME(0).bridgedTo(LocalTime.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_DATE_TIME, (DataType)DataTypes.TIMESTAMP(3).bridgedTo(LocalDateTime.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.INSTANT, (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(3).bridgedTo(Instant.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_DATE, (DataType)DataTypes.DATE().bridgedTo(Date.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_TIME, (DataType)DataTypes.TIME(0).bridgedTo(Time.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_TIMESTAMP, (DataType)DataTypes.TIMESTAMP(3).bridgedTo(Timestamp.class));
        LegacyTypeInfoDataTypeConverter.addMapping(TimeIntervalTypeInfo.INTERVAL_MONTHS, (DataType)DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.class));
        LegacyTypeInfoDataTypeConverter.addMapping(TimeIntervalTypeInfo.INTERVAL_MILLIS, (DataType)DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.TYPE)).bridgedTo(boolean[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.BYTES().bridgedTo(byte[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.SMALLINT().notNull()).bridgedTo(Short.TYPE)).bridgedTo(short[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)).bridgedTo(int[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)).bridgedTo(long[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE)).bridgedTo(float[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)).bridgedTo(double[].class));
    }
}

