/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite3.client.RetryLimitPolicy;
import org.apache.ignite3.internal.client.PayloadOutputChannel;
import org.apache.ignite3.internal.client.WriteContext;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.sql.ClientSql;
import org.apache.ignite3.internal.client.table.AbstractClientView;
import org.apache.ignite3.internal.client.table.ClientDataStreamer;
import org.apache.ignite3.internal.client.table.ClientRecordSerializer;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTable;
import org.apache.ignite3.internal.client.table.ClientTupleSerializer;
import org.apache.ignite3.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite3.internal.client.table.PojoStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.TupleReader;
import org.apache.ignite3.internal.streamer.StreamerBatchSender;
import org.apache.ignite3.internal.table.criteria.SqlRowProjection;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientRecordView<R>
extends AbstractClientView<R>
implements RecordView<R> {
    private final ClientRecordSerializer<R> ser;

    ClientRecordView(ClientTable tbl, ClientSql sql, Mapper<R> recMapper) {
        super(tbl, sql);
        this.ser = new ClientRecordSerializer<R>(tbl.tableId(), recMapper);
    }

    @Override
    public R get(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    @Override
    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, "keyRecs", "key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(15, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), true, TuplePart.KEY_AND_VAL), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRecs.iterator().next()));
        }
        return this.tbl.split(tx, keyRecs, clo, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public boolean contains(@Nullable Transaction tx, R key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s, w, n) -> this.ser.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), key), tx);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(67, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), r -> r.in().unpackBoolean(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keys.iterator().next()));
        }
        return this.tbl.split(tx, keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(13, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> null, (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, null, (agg, cur) -> null, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public boolean insert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(20, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s, w, n) -> this.ser.writeRecs(tx, oldRec, newRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), oldRec), tx);
    }

    @Override
    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    @Override
    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    @Override
    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(29, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRecs.iterator().next()));
        }
        return this.tbl.split(tx, keyRecs, clo, new ArrayList(keyRecs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    @Override
    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(31, (s, w, n) -> this.ser.writeRecs(tx, (Collection<R>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        PojoStreamerPartitionAwarenessProvider<R> provider = new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper());
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s, w, n) -> this.ser.writeStreamerRecs((int)partition, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    @Override
    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper()), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    @Override
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] cols = ClientRecordView.columnNames(schema.columns());
        Marshaller marsh = schema.getMarshaller(this.ser.mapper(), TuplePart.KEY_AND_VAL, true);
        return row -> marsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, cols)), null);
    }
}

