/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.client.TcpClientChannel;
import org.apache.ignite3.internal.future.timeout.TimeoutWorker;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.NamedThreadFactory;
import org.apache.ignite3.internal.util.FastTimestamps;
import org.jetbrains.annotations.Nullable;

final class ClientTimeoutWorker {
    static final ClientTimeoutWorker INSTANCE = new ClientTimeoutWorker();
    private static final int emptyCountThreshold = 10;
    @Nullable
    private ScheduledExecutorService executor = null;
    private final Set<TcpClientChannel> channels = ConcurrentHashMap.newKeySet();
    private int emptyCount;

    private ClientTimeoutWorker() {
    }

    synchronized void registerClientChannel(TcpClientChannel ch) {
        this.channels.add(ch);
        this.emptyCount = 0;
        if (this.executor == null) {
            this.executor = ClientTimeoutWorker.createExecutor();
            this.emptyCount = 0;
            long sleepInterval = TimeoutWorker.getSleepInterval();
            this.executor.scheduleAtFixedRate(this::checkTimeouts, sleepInterval, sleepInterval, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void shutdownIfEmpty() {
        if (this.executor != null && this.channels.isEmpty()) {
            ++this.emptyCount;
            if (this.emptyCount >= 10) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("TcpClientChannel-timeout-worker", Loggers.voidLogger()));
    }

    private void checkTimeouts() {
        long now = FastTimestamps.coarseCurrentTimeMillis();
        for (TcpClientChannel ch : this.channels) {
            if (ch.closed()) {
                this.channels.remove(ch);
            }
            ch.checkTimeouts(now);
        }
        this.shutdownIfEmpty();
    }
}

