/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite3.internal.network.serialization.Classes;
import org.apache.ignite3.internal.network.serialization.marshal.MarshallingNotSupportedException;
import org.jetbrains.annotations.Nullable;

class MarshallingValidations {
    private final Map<Class<?>, Marshallability> marshallabilityMap = new ConcurrentHashMap();
    private final Function<Class<?>, Marshallability> marshallabilityFunction = this::marshallability;

    MarshallingValidations() {
    }

    void throwIfMarshallingNotSupported(@Nullable Object object) {
        if (object == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        Marshallability marshallability = this.marshallabilityMap.computeIfAbsent(objectClass, this.marshallabilityFunction);
        switch (marshallability) {
            case INNER_CLASS: {
                throw new MarshallingNotSupportedException("Non-static inner class instances are not supported for marshalling: " + objectClass);
            }
            case CAPTUREING_CLOSURE: {
                throw new MarshallingNotSupportedException("Capturing nested class instances are not supported for marshalling: " + object);
            }
            case NON_SERIALIZABLE_LAMBDA: {
                throw new MarshallingNotSupportedException("Non-serializable lambda instances are not supported for marshalling: " + object);
            }
        }
    }

    private Marshallability marshallability(Class<?> objectClass) {
        if (Enum.class.isAssignableFrom(objectClass)) {
            return Marshallability.OK;
        }
        if (this.isInnerClass(objectClass)) {
            return Marshallability.INNER_CLASS;
        }
        if (this.isCapturingClosure(objectClass)) {
            return Marshallability.CAPTUREING_CLOSURE;
        }
        if (this.isNonSerializableLambda(objectClass)) {
            return Marshallability.NON_SERIALIZABLE_LAMBDA;
        }
        return Marshallability.OK;
    }

    private boolean isInnerClass(Class<?> objectClass) {
        return !Modifier.isStatic(objectClass.getModifiers()) && objectClass.getDeclaringClass() != null;
    }

    private boolean isCapturingClosure(Class<?> objectClass) {
        for (Field field : objectClass.getDeclaredFields()) {
            if ((!field.isSynthetic() || !field.getName().equals("this$0")) && !field.getName().startsWith("arg$")) continue;
            return true;
        }
        return false;
    }

    private boolean isNonSerializableLambda(Class<?> objectClass) {
        return Classes.isLambda(objectClass) && !Classes.isSerializable(objectClass);
    }

    private static enum Marshallability {
        OK,
        INNER_CLASS,
        CAPTUREING_CLOSURE,
        NON_SERIALIZABLE_LAMBDA;

    }
}

