/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster;

import java.util.BitSet;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.AbstractTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.AllOfTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.PartitionedTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.SomeOfTarget;

class OneOfTarget
extends AbstractTarget {
    OneOfTarget(BitSet nodes) {
        super(nodes);
    }

    @Override
    public ExecutionTarget finalise() {
        if (this.nodes.cardinality() == 1) {
            return this;
        }
        return new OneOfTarget(OneOfTarget.pickOne(this.nodes));
    }

    @Override
    public ExecutionTarget colocateWith(ExecutionTarget other) throws ColocationMappingException {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        return ((AbstractTarget)other).colocate(this);
    }

    @Override
    public ExecutionTarget trimTo(ExecutionTarget other) {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        if (this.nodes.cardinality() == 1) {
            return this;
        }
        BitSet otherNodes = ((AbstractTarget)other).nodes;
        if (!this.nodes.equals(otherNodes) && this.nodes.intersects(otherNodes)) {
            BitSet newNodes = (BitSet)this.nodes.clone();
            newNodes.and(otherNodes);
            return new OneOfTarget(newNodes);
        }
        return this;
    }

    @Override
    public ExecutionTarget colocate(AllOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(other, this);
    }

    @Override
    public ExecutionTarget colocate(OneOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }

    @Override
    public ExecutionTarget colocate(PartitionedTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }

    @Override
    public ExecutionTarget colocate(SomeOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }
}

