/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.partition;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite3.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.partition.HashPartition;
import org.apache.ignite3.lang.UnsupportedPartitionTypeException;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.Partition;
import org.apache.ignite3.table.partition.PartitionManager;

public class HashPartitionManagerImpl
implements PartitionManager {
    private final InternalTable table;
    private final SchemaRegistry schemaReg;
    private final MarshallersProvider marshallers;

    public HashPartitionManagerImpl(InternalTable table, SchemaRegistry schemaReg, MarshallersProvider marshallers) {
        this.table = table;
        this.schemaReg = schemaReg;
        this.marshallers = marshallers;
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        if (!(partition instanceof HashPartition)) {
            throw new UnsupportedPartitionTypeException("Table " + this.table.name() + " doesn't support any other type of partition except hash partition.");
        }
        HashPartition hashPartition = (HashPartition)partition;
        return this.table.partitionLocation(hashPartition.partitionId()).thenApply(InternalClusterNode::toPublicNode);
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        int partitions = this.table.partitions();
        CompletableFuture[] futures = new CompletableFuture[partitions];
        for (int i = 0; i < partitions; ++i) {
            futures[i] = this.table.partitionLocation(i);
        }
        return CompletableFuture.allOf(futures).thenApply(unused -> {
            HashMap<HashPartition, ClusterNode> result = new HashMap<HashPartition, ClusterNode>(partitions);
            for (int i = 0; i < partitions; ++i) {
                result.put(new HashPartition(i), ((InternalClusterNode)futures[i].join()).toPublicNode());
            }
            return result;
        });
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mapper);
        KvMarshallerImpl<K, K> marshaller = new KvMarshallerImpl<K, K>(this.schemaReg.lastKnownSchema(), this.marshallers, mapper, mapper);
        Row keyRow = marshaller.marshal(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId(keyRow)));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = new TupleMarshallerImpl(this.schemaReg.lastKnownSchema()).marshalKey(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId(keyRow)));
    }
}

