/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.raft.jraft.core.Scheduler;
import org.apache.ignite3.raft.jraft.util.ThreadPoolUtil;

public class TimerManager
implements Scheduler {
    private static final IgniteLogger LOG = Loggers.forClass(TimerManager.class);
    private final ScheduledExecutorService executor;

    public TimerManager(int workerNum) {
        this(workerNum, "JRaft-Node-ScheduleThreadPool");
    }

    public TimerManager(int workerNum, String name) {
        this.executor = ThreadPoolUtil.newScheduledBuilder().poolName(name).coreThreads(workerNum).enableMetric(true).threadFactory(IgniteThreadFactory.createWithFixedPrefix(name, true, LOG, new ThreadOperation[0])).build();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
    }
}

