/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexRequestSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class ReadIndexRequestImpl
implements RpcRequests.ReadIndexRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3012;
    @IgniteStringifier(name="entriesList.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> entriesList;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;

    private ReadIndexRequestImpl(List<ByteBuffer> entriesList, String groupId, String peerId, String serverId) {
        this.entriesList = entriesList;
        this.groupId = groupId;
        this.peerId = peerId;
        this.serverId = serverId;
    }

    @Override
    public List<ByteBuffer> entriesList() {
        return this.entriesList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    public MessageSerializer serializer() {
        return ReadIndexRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ReadIndexRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3012;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadIndexRequestImpl otherMessage = (ReadIndexRequestImpl)other;
        return Objects.equals(this.entriesList, otherMessage.entriesList) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.entriesList, this.groupId, this.peerId, this.serverId);
        return result;
    }

    @Override
    public ReadIndexRequestImpl clone() {
        try {
            return (ReadIndexRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadIndexRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ReadIndexRequestBuilder {
        private List<ByteBuffer> entriesList;
        private String groupId;
        private String peerId;
        private String serverId;

        private Builder() {
        }

        @Override
        public ReadIndexRequestBuilder entriesList(List<ByteBuffer> entriesList) {
            this.entriesList = entriesList;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Override
        public List<ByteBuffer> entriesList() {
            return this.entriesList;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public RpcRequests.ReadIndexRequest build() {
            return new ReadIndexRequestImpl(this.entriesList, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.peerId, this.serverId);
        }
    }
}

