/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTimeSeriesPlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(AlterTimeSeriesPlan.class);
    private PartialPath path;
    private AlterTimeSeriesOperator.AlterType alterType;
    private Map<String, String> alterMap;
    private String alias;
    private Map<String, String> tagsMap;
    private Map<String, String> attributesMap;

    public AlterTimeSeriesPlan() {
        super(Operator.OperatorType.ALTER_TIMESERIES);
    }

    public AlterTimeSeriesPlan(PartialPath path, AlterTimeSeriesOperator.AlterType alterType, Map<String, String> alterMap, String alias, Map<String, String> tagsMap, Map<String, String> attributesMap) {
        super(Operator.OperatorType.ALTER_TIMESERIES);
        this.path = path;
        this.alterType = alterType;
        this.alterMap = alterMap;
        this.alias = alias;
        this.tagsMap = tagsMap;
        this.attributesMap = attributesMap;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public AlterTimeSeriesOperator.AlterType getAlterType() {
        return this.alterType;
    }

    public Map<String, String> getAlterMap() {
        return this.alterMap;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, String> getTagsMap() {
        return this.tagsMap;
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.ALTER_TIMESERIES.ordinal());
        byte[] bytes = this.path.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.write(this.alterType.ordinal());
        if (this.alias != null) {
            stream.write(1);
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.alterMap != null && !this.alterMap.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.alterMap, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.tagsMap != null && !this.tagsMap.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.tagsMap, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.attributesMap != null && !this.attributesMap.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributesMap, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        try {
            this.path = new PartialPath(new String(bytes));
        }
        catch (IllegalPathException e) {
            logger.error("Illegal path in plan deserialization:", (Throwable)e);
        }
        this.alterType = AlterTimeSeriesOperator.AlterType.values()[buffer.get()];
        if (buffer.get() == 1) {
            this.alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.alterMap = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.tagsMap = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.attributesMap = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterTimeSeriesPlan that = (AlterTimeSeriesPlan)o;
        return Objects.equals(this.path, that.path) && this.alterType == that.alterType && Objects.equals(this.alterMap, that.alterMap) && Objects.equals(this.alias, that.alias) && Objects.equals(this.tagsMap, that.tagsMap) && Objects.equals(this.attributesMap, that.attributesMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.alias, this.alterType, this.alterMap, this.attributesMap, this.tagsMap});
    }
}

