/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.tracing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.tracing.TracingInfo;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;

public class TracingManager {
    private final Map<Long, TracingInfo> queryIdToTracingInfo = new ConcurrentHashMap<Long, TracingInfo>();

    public static TracingManager getInstance() {
        return TracingManagerHelper.INSTANCE;
    }

    private TracingInfo getTracingInfo(long queryId) {
        return this.queryIdToTracingInfo.computeIfAbsent(queryId, k -> new TracingInfo());
    }

    public void setSeriesPathNum(long queryId, int pathsNum) {
        this.getTracingInfo(queryId).setSeriesPathNum(pathsNum);
    }

    public void addTsFileSet(long queryId, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        this.getTracingInfo(queryId).addTsFileSet(seqResources, unseqResources);
    }

    public void addTsFile(long queryId, TsFileResource tsFileResource, boolean isSeq) {
        this.getTracingInfo(queryId).addTsFile(tsFileResource, isSeq);
    }

    public void addChunkInfo(long queryId, int chunkNum, long pointsNum, boolean seq) {
        this.getTracingInfo(queryId).addChunkInfo(chunkNum, pointsNum, seq);
    }

    public void addTotalPageNum(long queryId, int pageNum) {
        this.getTracingInfo(queryId).addTotalPageNum(pageNum);
    }

    public void addOverlappedPageNum(long queryId) {
        this.getTracingInfo(queryId).addOverlappedPageNum();
    }

    public void setStartTime(long queryId, long startTime, String statement) {
        this.getTracingInfo(queryId).setStartTime(startTime);
        this.registerActivity(queryId, String.format("Start to execute statement: %s", statement), startTime);
    }

    public void registerActivity(long queryId, String activity, long startTime) {
        this.getTracingInfo(queryId).addActivity(activity, startTime);
    }

    public TSTracingInfo fillRpcReturnTracingInfo(long queryId) {
        return this.queryIdToTracingInfo.remove(queryId).fillRpcReturnTracingInfo();
    }

    private static class TracingManagerHelper {
        private static final TracingManager INSTANCE = new TracingManager();

        private TracingManagerHelper() {
        }
    }
}

