/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFTimeDifference
implements UDTF {
    private boolean hasPrevious = false;
    private long previousTime = 0L;

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(TSDataType.INT64);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws IOException {
        if (!this.hasPrevious) {
            this.previousTime = row.getTime();
            this.hasPrevious = true;
            return;
        }
        long currentTime = row.getTime();
        collector.putLong(currentTime, currentTime - this.previousTime);
        this.previousTime = currentTime;
    }
}

