/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Objects;
import java.util.Random;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;

class LRUCacheEntryManager<FK, SK, V>
implements ICacheEntryManager<FK, SK, V, LRUCacheEntry<SK, V>> {
    private static final int SLOT_NUM = 128;
    private final LRULinkedList[] lruLinkedLists = new LRULinkedList[128];
    private final Random idxGenerator = new Random();

    LRUCacheEntryManager() {
    }

    @Override
    public LRUCacheEntry<SK, V> createCacheEntry(SK secondKey, V value, ICacheEntryGroup<FK, SK, V, LRUCacheEntry<SK, V>> cacheEntryGroup) {
        return new LRUCacheEntry(secondKey, value, cacheEntryGroup);
    }

    @Override
    public void access(LRUCacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).moveToHead(cacheEntry);
    }

    @Override
    public void put(LRUCacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).add(cacheEntry);
    }

    @Override
    public void invalid(LRUCacheEntry<SK, V> cacheEntry) {
        ((LRUCacheEntry)cacheEntry).next.pre = ((LRUCacheEntry)cacheEntry).pre;
        ((LRUCacheEntry)cacheEntry).pre.next = ((LRUCacheEntry)cacheEntry).next;
        ((LRUCacheEntry)cacheEntry).next = null;
        ((LRUCacheEntry)cacheEntry).pre = null;
    }

    @Override
    public LRUCacheEntry<SK, V> evict() {
        int startIndex = this.idxGenerator.nextInt(128);
        for (int i = 0; i < 128; ++i) {
            LRUCacheEntry cacheEntry;
            LRULinkedList lruLinkedList;
            if (startIndex == 128) {
                startIndex = 0;
            }
            if ((lruLinkedList = this.lruLinkedLists[startIndex]) != null && (cacheEntry = lruLinkedList.evict()) != null) {
                return cacheEntry;
            }
            ++startIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            for (int i = 0; i < 128; ++i) {
                this.lruLinkedLists[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LRULinkedList getBelongedList(LRUCacheEntry<SK, V> cacheEntry) {
        int slotIndex = cacheEntry.hashCode() % 128;
        slotIndex = slotIndex < 0 ? slotIndex + 128 : slotIndex;
        LRULinkedList lruLinkedList = this.lruLinkedLists[slotIndex];
        if (lruLinkedList != null) return lruLinkedList;
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            lruLinkedList = this.lruLinkedLists[slotIndex];
            if (lruLinkedList != null) return lruLinkedList;
            this.lruLinkedLists[slotIndex] = lruLinkedList = new LRULinkedList();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lruLinkedList;
        }
    }

    private static class LRULinkedList {
        private final LRUCacheEntry head = new LRUCacheEntry(null, null, null);
        private final LRUCacheEntry tail = new LRUCacheEntry(null, null, null);

        public LRULinkedList() {
            this.head.next = this.tail;
            this.tail.pre = this.head;
        }

        synchronized void add(LRUCacheEntry cacheEntry) {
            cacheEntry.next = this.head.next;
            cacheEntry.pre = this.head;
            this.head.next.pre = cacheEntry;
            this.head.next = cacheEntry;
        }

        synchronized LRUCacheEntry evict() {
            if (this.tail.pre == this.head) {
                return null;
            }
            LRUCacheEntry cacheEntry = this.tail.pre;
            cacheEntry.pre.next = cacheEntry.next;
            cacheEntry.next.pre = cacheEntry.pre;
            cacheEntry.next = null;
            cacheEntry.pre = null;
            return cacheEntry;
        }

        synchronized void moveToHead(LRUCacheEntry cacheEntry) {
            if (cacheEntry.next == null || cacheEntry.pre == null) {
                return;
            }
            cacheEntry.pre.next = cacheEntry.next;
            cacheEntry.next.pre = cacheEntry.pre;
            cacheEntry.next = this.head.next;
            cacheEntry.pre = this.head;
            this.head.next.pre = cacheEntry;
            this.head.next = cacheEntry;
        }
    }

    static class LRUCacheEntry<SK, V>
    implements ICacheEntry<SK, V> {
        private final SK secondKey;
        private volatile ICacheEntryGroup cacheEntryGroup;
        private V value;
        private LRUCacheEntry<SK, V> pre;
        private LRUCacheEntry<SK, V> next;

        private LRUCacheEntry(SK secondKey, V value, ICacheEntryGroup cacheEntryGroup) {
            this.secondKey = secondKey;
            this.value = value;
            this.cacheEntryGroup = cacheEntryGroup;
        }

        @Override
        public SK getSecondKey() {
            return this.secondKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public ICacheEntryGroup getBelongedGroup() {
            return this.cacheEntryGroup;
        }

        @Override
        public void setBelongedGroup(ICacheEntryGroup belongedGroup) {
            this.cacheEntryGroup = belongedGroup;
        }

        @Override
        public void replaceValue(V newValue) {
            this.value = newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LRUCacheEntry that = (LRUCacheEntry)o;
            return Objects.equals(this.secondKey, that.secondKey) && Objects.equals(this.cacheEntryGroup, that.cacheEntryGroup);
        }

        public int hashCode() {
            return this.cacheEntryGroup.hashCode() * 31 + this.secondKey.hashCode();
        }
    }
}

