/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.impl;

import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.common.DeviceMNodeWrapper;
import org.apache.iotdb.commons.schema.node.info.IDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.basic.BasicMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.container.MemMNodeContainer;

public class BasicInternalMNode
extends BasicMNode
implements IInternalMNode<IMemMNode> {
    private volatile transient IMNodeContainer<IMemMNode> children = null;
    private volatile IDeviceInfo<IMemMNode> deviceInfo = null;

    public BasicInternalMNode(IMemMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey((Object)name) || this.hasChildInDeviceInfo(name);
    }

    private boolean hasChildInDeviceInfo(String name) {
        return this.deviceInfo != null && this.deviceInfo.hasAliasChild(name);
    }

    @Override
    public IMemMNode getChild(String name) {
        IMemMNode child = null;
        if (this.children != null) {
            child = (IMemMNode)this.children.get((Object)name);
        }
        if (child == null && this.deviceInfo != null) {
            child = (IMemMNode)this.deviceInfo.getAliasChild(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemMNode addChild(String name, IMemMNode child) {
        if (this.children == null) {
            BasicInternalMNode basicInternalMNode = this;
            synchronized (basicInternalMNode) {
                if (this.children == null) {
                    this.children = new MemMNodeContainer();
                }
            }
        }
        child.setParent(this);
        IMemMNode existingChild = (IMemMNode)this.children.putIfAbsent((Object)name, (Object)child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemMNode addChild(IMemMNode child) {
        if (this.children == null) {
            BasicInternalMNode basicInternalMNode = this;
            synchronized (basicInternalMNode) {
                if (this.children == null) {
                    this.children = new MemMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent((Object)child.getName(), (Object)child);
        return child;
    }

    @Override
    public IMemMNode deleteChild(String name) {
        if (this.children != null) {
            return (IMemMNode)this.children.remove((Object)name);
        }
        return null;
    }

    @Override
    public IMNodeContainer<IMemMNode> getChildren() {
        if (this.children == null) {
            return MemMNodeContainer.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer<IMemMNode> children) {
        this.children = children;
    }

    @Override
    public int estimateSize() {
        return 88 + super.estimateSize() + 8 + (this.deviceInfo == null ? 0 : this.deviceInfo.estimateSize());
    }

    @Override
    public MNodeType getMNodeType() {
        return this.deviceInfo == null ? MNodeType.INTERNAL : MNodeType.DEVICE;
    }

    @Override
    public boolean isDevice() {
        return this.getDeviceInfo() != null;
    }

    @Override
    public IInternalMNode<IMemMNode> getAsInternalMNode() {
        return this;
    }

    @Override
    public IDeviceMNode<IMemMNode> getAsDeviceMNode() {
        if (this.isDevice()) {
            return new DeviceMNodeWrapper((IInternalMNode)this);
        }
        throw new UnsupportedOperationException("Wrong node type");
    }

    public IDeviceInfo<IMemMNode> getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(IDeviceInfo<IMemMNode> deviceInfo) {
        this.deviceInfo = deviceInfo;
    }
}

