/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureMetrics.class);
    private final ProcedureManager procedureManager;
    private final ProcedureExecutor<ConfigNodeProcedureEnv> executor;
    private final ProcedureScheduler scheduler;
    private final Map<String, ProcedureMetricItems> metricItemsMap = new ConcurrentHashMap<String, ProcedureMetricItems>();
    private AbstractMetricService metricService;

    public ProcedureMetrics(ProcedureManager procedureManager) {
        this.procedureManager = procedureManager;
        this.executor = procedureManager.getExecutor();
        this.scheduler = procedureManager.getScheduler();
    }

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        this.bindThreadMetrics(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindThreadMetrics(metricService);
        for (ProcedureMetricItems items : this.metricItemsMap.values()) {
            items.unbindMetricItems(metricService);
        }
        this.metricItemsMap.clear();
    }

    private void bindThreadMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PROCEDURE_WORKER_THREAD_COUNT.toString(), MetricLevel.CORE, this.executor, ProcedureExecutor::getWorkerThreadCount, new String[0]);
        metricService.createAutoGauge(Metric.PROCEDURE_ACTIVE_WORKER_THREAD_COUNT.toString(), MetricLevel.CORE, this.executor, ProcedureExecutor::getActiveWorkerThreadCount, new String[0]);
        metricService.createAutoGauge(Metric.PROCEDURE_QUEUE_LENGTH.toString(), MetricLevel.CORE, (Object)this.scheduler, ProcedureScheduler::size, new String[0]);
    }

    private void unbindThreadMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PROCEDURE_WORKER_THREAD_COUNT.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PROCEDURE_ACTIVE_WORKER_THREAD_COUNT.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PROCEDURE_QUEUE_LENGTH.toString(), new String[0]);
    }

    public void updateMetricsOnSubmit(String procType) {
        Optional.ofNullable(this.metricService).ifPresent(service -> this.metricItemsMap.computeIfAbsent(procType, k -> new ProcedureMetricItems((String)k, (AbstractMetricService)service)).updateMetricsOnSubmit());
    }

    public void updateMetricsOnFinish(String procType, long runtime, boolean success) {
        Optional.ofNullable(this.metricService).ifPresent(service -> this.metricItemsMap.computeIfAbsent(procType, k -> new ProcedureMetricItems((String)k, (AbstractMetricService)service)).updateMetricsOnFinish(runtime, success));
    }

    class ProcedureMetricItems {
        private final String procType;
        private Counter submittedCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        private Counter failedCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        private Timer executionTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

        public ProcedureMetricItems(String procType, AbstractMetricService metricService) {
            this.procType = procType;
            this.bindMetricItems(metricService);
        }

        public void bindMetricItems(AbstractMetricService metricService) {
            this.submittedCounter = metricService.getOrCreateCounter(Metric.PROCEDURE_SUBMITTED_COUNT.toString(), MetricLevel.CORE, new String[]{Tag.TYPE.toString(), this.procType});
            this.failedCounter = metricService.getOrCreateCounter(Metric.PROCEDURE_FAILED_COUNT.toString(), MetricLevel.CORE, new String[]{Tag.TYPE.toString(), this.procType});
            this.executionTimer = metricService.getOrCreateTimer(Metric.PROCEDURE_EXECUTION_TIME.toString(), MetricLevel.CORE, new String[]{Tag.TYPE.toString(), this.procType});
        }

        public void unbindMetricItems(AbstractMetricService metricService) {
            metricService.remove(MetricType.COUNTER, Metric.PROCEDURE_SUBMITTED_COUNT.toString(), new String[]{Tag.TYPE.toString(), this.procType});
            metricService.remove(MetricType.COUNTER, Metric.PROCEDURE_FAILED_COUNT.toString(), new String[]{Tag.TYPE.toString(), this.procType});
            metricService.remove(MetricType.TIMER, Metric.PROCEDURE_EXECUTION_TIME.toString(), new String[]{Tag.TYPE.toString(), this.procType});
        }

        public void updateMetricsOnSubmit() {
            this.submittedCounter.inc();
        }

        public void updateMetricsOnFinish(long runtime, boolean success) {
            if (success) {
                this.executionTimer.updateMillis(runtime);
            } else {
                this.failedCounter.inc();
            }
        }
    }
}

