/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class IssuedIdentityToken
extends UserIdentityToken
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=938");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=939");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=940");
    private final ByteString tokenData;
    private final String encryptionAlgorithm;

    public IssuedIdentityToken(String policyId, ByteString tokenData, String encryptionAlgorithm) {
        super(policyId);
        this.tokenData = tokenData;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ByteString getTokenData() {
        return this.tokenData;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    protected IssuedIdentityToken(IssuedIdentityTokenBuilder<?, ?> b) {
        super((UserIdentityToken.UserIdentityTokenBuilder<?, ?>)b);
        this.tokenData = ((IssuedIdentityTokenBuilder)b).tokenData;
        this.encryptionAlgorithm = ((IssuedIdentityTokenBuilder)b).encryptionAlgorithm;
    }

    public static IssuedIdentityTokenBuilder<?, ?> builder() {
        return new IssuedIdentityTokenBuilderImpl();
    }

    public IssuedIdentityTokenBuilder<?, ?> toBuilder() {
        return new IssuedIdentityTokenBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssuedIdentityToken)) {
            return false;
        }
        IssuedIdentityToken other = (IssuedIdentityToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteString this$tokenData = this.getTokenData();
        ByteString other$tokenData = other.getTokenData();
        if (this$tokenData == null ? other$tokenData != null : !((Object)this$tokenData).equals(other$tokenData)) {
            return false;
        }
        String this$encryptionAlgorithm = this.getEncryptionAlgorithm();
        String other$encryptionAlgorithm = other.getEncryptionAlgorithm();
        return !(this$encryptionAlgorithm == null ? other$encryptionAlgorithm != null : !this$encryptionAlgorithm.equals(other$encryptionAlgorithm));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IssuedIdentityToken;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ByteString $tokenData = this.getTokenData();
        result = result * 59 + ($tokenData == null ? 43 : ((Object)$tokenData).hashCode());
        String $encryptionAlgorithm = this.getEncryptionAlgorithm();
        result = result * 59 + ($encryptionAlgorithm == null ? 43 : $encryptionAlgorithm.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "IssuedIdentityToken(tokenData=" + this.getTokenData() + ", encryptionAlgorithm=" + this.getEncryptionAlgorithm() + ")";
    }

    private static final class IssuedIdentityTokenBuilderImpl
    extends IssuedIdentityTokenBuilder<IssuedIdentityToken, IssuedIdentityTokenBuilderImpl> {
        private IssuedIdentityTokenBuilderImpl() {
        }

        @Override
        protected IssuedIdentityTokenBuilderImpl self() {
            return this;
        }

        @Override
        public IssuedIdentityToken build() {
            return new IssuedIdentityToken(this);
        }
    }

    public static abstract class IssuedIdentityTokenBuilder<C extends IssuedIdentityToken, B extends IssuedIdentityTokenBuilder<C, B>>
    extends UserIdentityToken.UserIdentityTokenBuilder<C, B> {
        private ByteString tokenData;
        private String encryptionAlgorithm;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            IssuedIdentityTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(IssuedIdentityToken instance, IssuedIdentityTokenBuilder<?, ?> b) {
            b.tokenData(instance.tokenData);
            b.encryptionAlgorithm(instance.encryptionAlgorithm);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tokenData(ByteString tokenData) {
            this.tokenData = tokenData;
            return (B)this.self();
        }

        public B encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "IssuedIdentityToken.IssuedIdentityTokenBuilder(super=" + super.toString() + ", tokenData=" + this.tokenData + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<IssuedIdentityToken> {
        @Override
        public Class<IssuedIdentityToken> getType() {
            return IssuedIdentityToken.class;
        }

        @Override
        public IssuedIdentityToken decode(SerializationContext context, UaDecoder decoder) {
            String policyId = decoder.readString("PolicyId");
            ByteString tokenData = decoder.readByteString("TokenData");
            String encryptionAlgorithm = decoder.readString("EncryptionAlgorithm");
            return new IssuedIdentityToken(policyId, tokenData, encryptionAlgorithm);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, IssuedIdentityToken value) {
            encoder.writeString("PolicyId", value.getPolicyId());
            encoder.writeByteString("TokenData", value.getTokenData());
            encoder.writeString("EncryptionAlgorithm", value.getEncryptionAlgorithm());
        }
    }
}

