/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadTsFileAbstractMemoryBlock
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileAbstractMemoryBlock.class);
    protected static final LoadTsFileMemoryManager MEMORY_MANAGER = LoadTsFileMemoryManager.getInstance();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public boolean hasEnoughMemory() {
        return this.hasEnoughMemory(0L);
    }

    public abstract boolean hasEnoughMemory(long var1);

    public abstract void addMemoryUsage(long var1);

    public abstract void reduceMemoryUsage(long var1);

    protected abstract void releaseAllMemory();

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.releaseAllMemory();
            }
            catch (Exception e) {
                LOGGER.error("Release memory block {} failed", (Object)this, (Object)e);
            }
        }
    }
}

