/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match.utils;

public class LinearScale<T extends Number> {
    private final double domainStart;
    private final double domainEnd;
    private final double rangeStart;
    private final double rangeEnd;

    public LinearScale(T domainStart, T domainEnd, double rangeStart, double rangeEnd) {
        this.domainStart = ((Number)domainStart).doubleValue();
        this.domainEnd = ((Number)domainEnd).doubleValue();
        if (this.domainStart >= this.domainEnd) {
            throw new IllegalArgumentException("domainStart must be less than domainEnd");
        }
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public double scale(T value) {
        double val = ((Number)value).doubleValue();
        if (val < this.domainStart || val > this.domainEnd) {
            throw new IllegalArgumentException("Value out of domain range");
        }
        return this.rangeStart + (this.rangeEnd - this.rangeStart) * (val - this.domainStart) / (this.domainEnd - this.domainStart);
    }
}

