/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.LifeCycle;

public interface DivisionInfo {
    public RaftProtos.RaftPeerRole getCurrentRole();

    default public boolean isFollower() {
        return this.getCurrentRole() == RaftProtos.RaftPeerRole.FOLLOWER;
    }

    default public boolean isCandidate() {
        return this.getCurrentRole() == RaftProtos.RaftPeerRole.CANDIDATE;
    }

    default public boolean isLeader() {
        return this.getCurrentRole() == RaftProtos.RaftPeerRole.LEADER;
    }

    default public boolean isListener() {
        return this.getCurrentRole() == RaftProtos.RaftPeerRole.LISTENER;
    }

    public boolean isLeaderReady();

    public RaftPeerId getLeaderId();

    public LifeCycle.State getLifeCycleState();

    default public boolean isAlive() {
        return !this.getLifeCycleState().isClosingOrClosed();
    }

    public RaftProtos.RoleInfoProto getRoleInfoProto();

    public long getCurrentTerm();

    public long getLastAppliedIndex();

    public long[] getFollowerNextIndices();

    public long[] getFollowerMatchIndices();
}

