/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.enumerated.FilterOperator;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ContentFilterElement
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=583");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=584");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=585");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15204");
    private final FilterOperator filterOperator;
    private final ExtensionObject[] filterOperands;

    public ContentFilterElement(FilterOperator filterOperator, ExtensionObject[] filterOperands) {
        this.filterOperator = filterOperator;
        this.filterOperands = filterOperands;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public FilterOperator getFilterOperator() {
        return this.filterOperator;
    }

    public ExtensionObject[] getFilterOperands() {
        return this.filterOperands;
    }

    protected ContentFilterElement(ContentFilterElementBuilder<?, ?> b) {
        super(b);
        this.filterOperator = ((ContentFilterElementBuilder)b).filterOperator;
        this.filterOperands = ((ContentFilterElementBuilder)b).filterOperands;
    }

    public static ContentFilterElementBuilder<?, ?> builder() {
        return new ContentFilterElementBuilderImpl();
    }

    public ContentFilterElementBuilder<?, ?> toBuilder() {
        return new ContentFilterElementBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentFilterElement)) {
            return false;
        }
        ContentFilterElement other = (ContentFilterElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterOperator this$filterOperator = this.getFilterOperator();
        FilterOperator other$filterOperator = other.getFilterOperator();
        if (this$filterOperator == null ? other$filterOperator != null : !this$filterOperator.equals(other$filterOperator)) {
            return false;
        }
        return Arrays.deepEquals(this.getFilterOperands(), other.getFilterOperands());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentFilterElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterOperator $filterOperator = this.getFilterOperator();
        result = result * 59 + ($filterOperator == null ? 43 : $filterOperator.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFilterOperands());
        return result;
    }

    @Override
    public String toString() {
        return "ContentFilterElement(filterOperator=" + this.getFilterOperator() + ", filterOperands=" + Arrays.deepToString(this.getFilterOperands()) + ")";
    }

    private static final class ContentFilterElementBuilderImpl
    extends ContentFilterElementBuilder<ContentFilterElement, ContentFilterElementBuilderImpl> {
        private ContentFilterElementBuilderImpl() {
        }

        @Override
        protected ContentFilterElementBuilderImpl self() {
            return this;
        }

        @Override
        public ContentFilterElement build() {
            return new ContentFilterElement(this);
        }
    }

    public static abstract class ContentFilterElementBuilder<C extends ContentFilterElement, B extends ContentFilterElementBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private FilterOperator filterOperator;
        private ExtensionObject[] filterOperands;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ContentFilterElementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ContentFilterElement instance, ContentFilterElementBuilder<?, ?> b) {
            b.filterOperator(instance.filterOperator);
            b.filterOperands(instance.filterOperands);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B filterOperator(FilterOperator filterOperator) {
            this.filterOperator = filterOperator;
            return (B)this.self();
        }

        public B filterOperands(ExtensionObject[] filterOperands) {
            this.filterOperands = filterOperands;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContentFilterElement.ContentFilterElementBuilder(super=" + super.toString() + ", filterOperator=" + this.filterOperator + ", filterOperands=" + Arrays.deepToString(this.filterOperands) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ContentFilterElement> {
        @Override
        public Class<ContentFilterElement> getType() {
            return ContentFilterElement.class;
        }

        @Override
        public ContentFilterElement decode(SerializationContext context, UaDecoder decoder) {
            FilterOperator filterOperator = decoder.readEnum("FilterOperator", FilterOperator.class);
            ExtensionObject[] filterOperands = decoder.readExtensionObjectArray("FilterOperands");
            return new ContentFilterElement(filterOperator, filterOperands);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ContentFilterElement value) {
            encoder.writeEnum("FilterOperator", value.getFilterOperator());
            encoder.writeExtensionObjectArray("FilterOperands", value.getFilterOperands());
        }
    }
}

