/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.multichildren;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class AbstractMultiChildrenFilter
extends SchemaFilter {
    private final List<SchemaFilter> children;

    protected AbstractMultiChildrenFilter(List<SchemaFilter> children) {
        this.children = children;
    }

    protected AbstractMultiChildrenFilter(ByteBuffer byteBuffer) {
        int num = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.children = new ArrayList<SchemaFilter>();
        for (int i = 0; i < num; ++i) {
            this.children.add(SchemaFilter.deserialize(byteBuffer));
        }
    }

    public List<SchemaFilter> getChildren() {
        return this.children;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.children.size(), (ByteBuffer)byteBuffer);
        for (SchemaFilter child : this.children) {
            SchemaFilter.serialize(child, byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)stream);
        for (SchemaFilter child : this.children) {
            SchemaFilter.serialize(child, stream);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMultiChildrenFilter that = (AbstractMultiChildrenFilter)o;
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }
}

