/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.tsfile.utils.Pair;

public class SubscriptionStates {
    private final Map<String, Long> topicNameToEventCount = new ConcurrentHashMap<String, Long>();

    @TestOnly
    public Pair<List<SubscriptionEvent>, List<SubscriptionEvent>> filter(List<SubscriptionEvent> events, long maxBytes) {
        ArrayList<SubscriptionEvent> eventsToPoll = new ArrayList<SubscriptionEvent>();
        ArrayList<SubscriptionEvent> eventsToNack = new ArrayList<SubscriptionEvent>();
        long totalSize = 0L;
        HashMap<String, Long> topicNameToIncrements = new HashMap<String, Long>();
        this.sort(events);
        for (SubscriptionEvent event : events) {
            long currentSize;
            try {
                currentSize = event.getCurrentResponseSize();
            }
            catch (IOException e) {
                eventsToNack.add(event);
                continue;
            }
            if (totalSize + currentSize < maxBytes) {
                eventsToPoll.add(event);
                totalSize += currentSize;
                topicNameToIncrements.merge(event.getCommitContext().getTopicName(), 1L, Long::sum);
                continue;
            }
            eventsToNack.add(event);
        }
        this.updateStates(topicNameToIncrements);
        return new Pair(eventsToPoll, eventsToNack);
    }

    private void sort(List<SubscriptionEvent> events) {
        events.sort(Comparator.comparingLong(event -> this.getStates(event.getCommitContext().getTopicName())));
    }

    public void updateStates(Map<String, Long> topicNameToIncrements) {
        for (Map.Entry<String, Long> entry : topicNameToIncrements.entrySet()) {
            this.topicNameToEventCount.merge(entry.getKey(), entry.getValue(), Long::sum);
        }
    }

    public long getStates(String topicName) {
        return this.topicNameToEventCount.getOrDefault(topicName, 0L);
    }
}

