/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.data.AbstractImportData;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;

public class ImportDataTree
extends AbstractImportData {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static SessionPool sessionPool;

    @Override
    public void init() throws InterruptedException, IoTDBConnectionException, StatementExecutionException {
        File file;
        sessionPool = new SessionPool.Builder().host(host).port(Integer.parseInt(port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).build();
        sessionPool.setEnableQueryRedirection(false);
        if (timeZoneID != null) {
            sessionPool.setTimeZone(timeZoneID);
            zoneId = sessionPool.getZoneId();
        }
        if (!(file = new File(targetPath)).isFile() && !file.isDirectory()) {
            ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
            System.exit(1);
        }
        if ("tsfile".equalsIgnoreCase(fileType)) {
            ImportTsFileScanTool.setSourceFullPath(targetPath);
            ImportTsFileScanTool.traverseAndCollectFiles();
            ImportTsFileScanTool.addNoResourceOrModsToQueue();
        } else {
            ImportDataScanTool.setSourceFullPath(targetPath);
            ImportDataScanTool.traverseAndCollectFiles();
        }
    }

    @Override
    protected Runnable getAsyncImportRunnable() {
        return new ImportDataTree();
    }

    @Override
    protected void importFromSqlFile(File file) {
        ArrayList<List<String>> failedRecords = new ArrayList<List<String>>();
        String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            String sql;
            while ((sql = br.readLine()) != null) {
                try {
                    sessionPool.executeNonQueryStatement(sql);
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {
                    failedRecords.add(Collections.singletonList(sql));
                }
            }
            this.processSuccessFile(null);
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (!failedRecords.isEmpty()) {
            try (FileWriter writer = new FileWriter(failedFilePath);){
                for (List list : failedRecords) {
                    writer.write(list.get(0).toString() + "\n");
                }
            }
            catch (IOException e) {
                ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            }
        }
    }

    @Override
    protected void importFromTsFile(File file) {
        String sql = "load '" + file + "' onSuccess=none ";
        try {
            sessionPool.executeNonQueryStatement(sql);
            this.processSuccessFile(file.getPath());
        }
        catch (Exception e) {
            this.processFailFile(file.getPath(), e);
        }
    }

    @Override
    protected void importFromCsvFile(File file) {
        if (file.getName().endsWith("csv") || file.getName().endsWith("txt")) {
            try {
                CSVParser csvRecords = ImportDataTree.readCsvFile(file.getAbsolutePath());
                List headerNames = csvRecords.getHeaderNames();
                Stream records = csvRecords.stream();
                if (headerNames.isEmpty()) {
                    ioTPrinter.println("Empty file!");
                    return;
                }
                if (!timeColumn.equalsIgnoreCase(ImportDataTree.filterBomHeader((String)headerNames.get(0)))) {
                    ioTPrinter.println("The first field of header must be `Time`!");
                    return;
                }
                String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                if (!deviceColumn.equalsIgnoreCase((String)headerNames.get(1))) {
                    ImportDataTree.writeDataAlignedByTime(headerNames, records, failedFilePath);
                } else {
                    ImportDataTree.writeDataAlignedByDevice(headerNames, records, failedFilePath);
                }
                this.processSuccessFile(null);
            }
            catch (IOException | IllegalPathException e) {
                ioTPrinter.println("CSV file read exception because: " + e.getMessage());
            }
        } else {
            ioTPrinter.println("The file name must end with \"csv\" or \"txt\"!");
        }
    }

    protected static void writeDataAlignedByTime(List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportDataTree.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        if (headerTypeMap.isEmpty()) {
            ImportDataTree.queryType(devices, headerTypeMap, "Time");
        }
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (Boolean.FALSE.equals(hasStarted.get())) {
                hasStarted.set(true);
            } else if (pointSize.get() >= batchPointSize) {
                ImportDataTree.writeAndEmptyDataSet(deviceIds, (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            boolean isFail = false;
            for (Map.Entry entry : deviceAndMeasurementNames.entrySet()) {
                String deviceId = (String)entry.getKey();
                List measurementNames = (List)entry.getValue();
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<String> measurements = new ArrayList<String>();
                for (String measurement : measurementNames) {
                    TSDataType type;
                    String header = deviceId + "." + measurement;
                    String value = recordObj.get((String)headerNameMap.get(header));
                    if ("".equals(value)) continue;
                    if (!headerTypeMap.containsKey(header)) {
                        ImportDataTree.queryType(header, headerTypeMap);
                        if (!headerTypeMap.containsKey(header)) {
                            type = ImportDataTree.typeInfer(value);
                            if (type != null) {
                                headerTypeMap.put(header, type);
                            } else {
                                ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), header, value);
                                isFail = true;
                            }
                        }
                    }
                    if ((type = (TSDataType)headerTypeMap.get(header)) == null) continue;
                    Object valueTrans = ImportDataTree.typeTrans(value, type);
                    if (valueTrans == null) {
                        isFail = true;
                        ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), header, value, type);
                        continue;
                    }
                    measurements.add(header.replace(deviceId + '.', ""));
                    types.add(type);
                    values.add(valueTrans);
                    pointSize.getAndIncrement();
                }
                if (measurements.isEmpty()) continue;
                times.add(ImportDataTree.parseTimestamp(recordObj.get(timeColumn)));
                deviceIds.add(deviceId);
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
            if (isFail) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
        });
        if (!deviceIds.isEmpty()) {
            ImportDataTree.writeAndEmptyDataSet(deviceIds, times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            ImportDataTree.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
    }

    protected static void writeDataAlignedByDevice(List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportDataTree.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        AtomicReference<Object> deviceName = new AtomicReference<Object>(null);
        HashSet typeQueriedDevice = new HashSet();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (deviceName.get() == null) {
                deviceName.set(recordObj.get(1));
            } else if (!Objects.equals(deviceName.get(), recordObj.get(1))) {
                ImportDataTree.writeAndEmptyDataSet((String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                deviceName.set(recordObj.get(1));
                pointSize.set(0);
            } else if (pointSize.get() >= batchPointSize) {
                ImportDataTree.writeAndEmptyDataSet((String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> measurements = new ArrayList<String>();
            AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
            for (Map.Entry headerNameEntry : headerNameMap.entrySet()) {
                TSDataType type;
                String headerNameWithoutType = (String)headerNameEntry.getKey();
                String headerName = (String)headerNameEntry.getValue();
                String value = recordObj.get(headerName);
                if ("".equals(value)) continue;
                if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                    if (!typeQueriedDevice.contains(deviceName.get())) {
                        if (headerTypeMap.isEmpty()) {
                            HashSet<String> devices = new HashSet<String>();
                            devices.add((String)deviceName.get());
                            ImportDataTree.queryType(devices, headerTypeMap, deviceColumn);
                        }
                        typeQueriedDevice.add((String)deviceName.get());
                    }
                    if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                        type = ImportDataTree.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(headerNameWithoutType, type);
                        } else {
                            ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), headerNameWithoutType, value);
                            isFail.set(true);
                        }
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerNameWithoutType)) == null) continue;
                Object valueTrans = ImportDataTree.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail.set(true);
                    ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), headerNameWithoutType, value, type);
                    continue;
                }
                values.add(valueTrans);
                measurements.add(headerNameWithoutType);
                types.add(type);
                pointSize.getAndIncrement();
            }
            if (Boolean.TRUE.equals(isFail.get())) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
            if (!measurements.isEmpty()) {
                times.add(ImportDataTree.parseTimestamp(recordObj.get(timeColumn)));
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
        });
        if (!times.isEmpty()) {
            ImportDataTree.writeAndEmptyDataSet(deviceName.get(), times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            ImportDataTree.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(String device, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        try {
            if (Boolean.FALSE.equals(aligned)) {
                sessionPool.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            } else {
                sessionPool.insertAlignedRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            }
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                ImportDataTree.writeAndEmptyDataSet(device, times, typesList, valuesList, measurementsList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
        }
        finally {
            times.clear();
            typesList.clear();
            valuesList.clear();
            measurementsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(List<String> deviceIds, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        try {
            if (Boolean.FALSE.equals(aligned)) {
                sessionPool.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
            } else {
                sessionPool.insertAlignedRecords(deviceIds, times, measurementsList, typesList, valuesList);
            }
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                ImportDataTree.writeAndEmptyDataSet(deviceIds, times, typesList, valuesList, measurementsList, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
            System.exit(1);
        }
        finally {
            deviceIds.clear();
            times.clear();
            typesList.clear();
            valuesList.clear();
            measurementsList.clear();
        }
    }

    private static void queryType(Set<String> deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) {
        for (String deviceName : deviceNames) {
            String sql = "show timeseries " + deviceName + ".*";
            try {
                SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
                try {
                    int tsIndex = sessionDataSetWrapper.getColumnNames().indexOf("Timeseries");
                    int dtIndex = sessionDataSetWrapper.getColumnNames().indexOf("DataType");
                    while (sessionDataSetWrapper.hasNext()) {
                        RowRecord rowRecord = sessionDataSetWrapper.next();
                        List fields = rowRecord.getFields();
                        String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                        String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                        if (Objects.equals(alignedType, "Time")) {
                            headerTypeMap.put(timeseries, ImportDataTree.getType(dataType));
                            continue;
                        }
                        if (!Objects.equals(alignedType, deviceColumn)) continue;
                        String[] split = PathUtils.splitPathToDetachedNodes((String)timeseries);
                        String measurement = split[split.length - 1];
                        headerTypeMap.put(measurement, ImportDataTree.getType(dataType));
                    }
                }
                finally {
                    if (sessionDataSetWrapper == null) continue;
                    sessionDataSetWrapper.close();
                }
            }
            catch (IllegalPathException | IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
                System.exit(1);
            }
        }
    }

    private static void queryType(String series, HashMap<String, TSDataType> headerTypeMap) {
        String sql = "show timeseries " + series;
        try (SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);){
            int tsIndex = sessionDataSetWrapper.getColumnNames().indexOf("Timeseries");
            int dtIndex = sessionDataSetWrapper.getColumnNames().indexOf("DataType");
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord rowRecord = sessionDataSetWrapper.next();
                List fields = rowRecord.getFields();
                String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                if (!Objects.equals(series, timeseries)) continue;
                headerTypeMap.put(timeseries, ImportDataTree.getType(dataType));
            }
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
            System.exit(1);
        }
    }
}

